/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractForwardCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public class ForwardCurve
extends AbstractForwardCurve
implements Serializable {
    private static final long serialVersionUID = -4126228588123963885L;
    private InterpolationEntityForward interpolationEntityForward = InterpolationEntityForward.FORWARD;

    public ForwardCurve(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendarInterface paymentBusinessdayCalendar, BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        super(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, discountCurveName);
        this.interpolationEntityForward = interpolationEntityForward;
        if (interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            super.addPoint(0.0, 1.0, false);
        }
    }

    public ForwardCurve(String name, LocalDate referenceDate, String paymentOffsetCode, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, new BusinessdayCalendarExcludingWeekends(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE, interpolationEntityForward, discountCurveName);
    }

    public ForwardCurve(String name, LocalDate referenceDate, String paymentOffsetCode, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, InterpolationEntityForward.FORWARD, discountCurveName);
    }

    public ForwardCurve(String name, double paymentOffset, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        super(name, null, paymentOffset, discountCurveName);
        this.interpolationEntityForward = interpolationEntityForward;
    }

    public static ForwardCurve createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendarInterface paymentBusinessdayCalendar, BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModelInterface model, double[] times, double[] givenForwards) {
        ForwardCurve forwardCurve = new ForwardCurve(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            forwardCurve.addForward(model, times[timeIndex], givenForwards[timeIndex], false);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromForwards(String name, Date referenceDate, String paymentOffsetCode, BusinessdayCalendarInterface paymentBusinessdayCalendar, BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModelInterface model, double[] times, double[] givenForwards) {
        return ForwardCurve.createForwardCurveFromForwards(name, referenceDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, discountCurveName, model, times, givenForwards);
    }

    public static ForwardCurve createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, String interpolationEntityForward, String discountCurveName, AnalyticModelInterface model, double[] times, double[] givenForwards) {
        return ForwardCurve.createForwardCurveFromForwards(name, referenceDate, paymentOffsetCode, InterpolationEntityForward.valueOf(interpolationEntityForward), discountCurveName, model, times, givenForwards);
    }

    public static ForwardCurve createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModelInterface model, double[] times, double[] givenForwards) {
        ForwardCurve forwardCurve = new ForwardCurve(name, referenceDate, paymentOffsetCode, interpolationEntityForward, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            forwardCurve.addForward(model, times[timeIndex], givenForwards[timeIndex], false);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromForwards(String name, double[] times, double[] givenForwards, double paymentOffset) {
        ForwardCurve forwardCurve = new ForwardCurve(name, paymentOffset, InterpolationEntityForward.FORWARD, null);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurve.addForward(null, fixingTime, givenForwards[timeIndex], isParameter);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors, double paymentOffset) {
        ForwardCurve forwardCurve = new ForwardCurve(name, paymentOffset, InterpolationEntityForward.FORWARD, null);
        if (times.length == 0) {
            throw new IllegalArgumentException("Vector of times must not be empty.");
        }
        if (times[0] > 0.0) {
            double forward = (1.0 / givenDiscountFactors[0] - 1.0) / (times[0] - 0.0);
            forwardCurve.addForward(null, 0.0, forward, true);
        }
        for (int timeIndex = 0; timeIndex < times.length - 1; ++timeIndex) {
            double forward = (givenDiscountFactors[timeIndex] / givenDiscountFactors[timeIndex + 1] - 1.0) / (times[timeIndex + 1] - times[timeIndex]);
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurve.addForward(null, fixingTime, forward, isParameter);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromForwards(String name, double[] times, double[] givenForwards, AnalyticModelInterface model, String discountCurveName, double paymentOffset) {
        ForwardCurve forwardCurve = new ForwardCurve(name, paymentOffset, InterpolationEntityForward.FORWARD, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurve.addForward(model, fixingTime, givenForwards[timeIndex], isParameter);
        }
        return forwardCurve;
    }

    @Override
    public double getForward(AnalyticModelInterface model, double fixingTime) {
        double paymentOffset = this.getPaymentOffset(fixingTime);
        double interpolationEntityForwardValue = this.getValue(model, fixingTime);
        switch (this.interpolationEntityForward) {
            default: {
                return interpolationEntityForwardValue;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                if (model == null) {
                    throw new IllegalArgumentException("model==null. Not allowed for interpolationEntityForward " + (Object)((Object)this.interpolationEntityForward));
                }
                return interpolationEntityForwardValue / model.getDiscountCurve(this.discountCurveName).getValue(model, fixingTime + paymentOffset);
            }
            case ZERO: {
                double interpolationEntityForwardValue2 = this.getValue(model, fixingTime + paymentOffset);
                return (Math.exp(interpolationEntityForwardValue2 * (fixingTime + paymentOffset) - interpolationEntityForwardValue * fixingTime) - 1.0) / paymentOffset;
            }
            case DISCOUNTFACTOR: 
        }
        double interpolationEntityForwardValue2 = this.getValue(model, fixingTime + paymentOffset);
        return (interpolationEntityForwardValue / interpolationEntityForwardValue2 - 1.0) / paymentOffset;
    }

    @Override
    public double getForward(AnalyticModelInterface model, double fixingTime, double paymentOffset) {
        return this.getForward(model, fixingTime);
    }

    private void addForward(AnalyticModelInterface model, double fixingTime, double forward, boolean isParameter) {
        double interpolationEntityForwardValue;
        double interpolationEntitiyTime;
        switch (this.interpolationEntityForward) {
            default: {
                interpolationEntitiyTime = fixingTime;
                interpolationEntityForwardValue = forward;
                break;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                interpolationEntitiyTime = fixingTime;
                interpolationEntityForwardValue = forward * model.getDiscountCurve(this.discountCurveName).getValue(model, fixingTime + this.getPaymentOffset(fixingTime));
                break;
            }
            case ZERO: {
                double paymentOffset = this.getPaymentOffset(fixingTime);
                interpolationEntitiyTime = fixingTime + paymentOffset;
                interpolationEntityForwardValue = Math.log(1.0 + forward * paymentOffset) / paymentOffset;
                break;
            }
            case DISCOUNTFACTOR: {
                double paymentOffset = this.getPaymentOffset(fixingTime);
                interpolationEntitiyTime = fixingTime + paymentOffset;
                interpolationEntityForwardValue = this.getValue(fixingTime) / (1.0 + forward * paymentOffset);
            }
        }
        super.addPoint(interpolationEntitiyTime, interpolationEntityForwardValue, isParameter);
    }

    @Override
    protected void addPoint(double time, double value, boolean isParameter) {
        if (this.interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            time += this.getPaymentOffset(time);
        }
        super.addPoint(time, value, isParameter);
    }

    public InterpolationEntityForward getInterpolationEntityForward() {
        return this.interpolationEntityForward;
    }

    @Override
    public String toString() {
        return "ForwardCurve [" + super.toString() + ", interpolationEntityForward=" + (Object)((Object)this.interpolationEntityForward) + "]";
    }

    public static enum InterpolationEntityForward {
        FORWARD,
        FORWARD_TIMES_DISCOUNTFACTOR,
        ZERO,
        DISCOUNTFACTOR;

    }
}

