/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.time.LocalDate;
import net.finmath.marketdata.model.curves.CurveInterface;

public abstract class AbstractCurve
implements CurveInterface,
Cloneable {
    private final LocalDate referenceDate;
    private final String name;

    public AbstractCurve(String name, LocalDate referenceDate) {
        this.name = name;
        this.referenceDate = referenceDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public double getValue(double time) {
        return this.getValue(null, time);
    }

    public double[] getValues(double[] times) {
        double[] values = new double[times.length];
        for (int i = 0; i < times.length; ++i) {
            values[i] = this.getValue(null, times[i]);
        }
        return values;
    }

    @Override
    public AbstractCurve clone() throws CloneNotSupportedException {
        return (AbstractCurve)super.clone();
    }

    @Override
    public CurveInterface getCloneForParameter(double[] value) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "AbstractCurve [name=" + this.name + ", referenceDate=" + this.referenceDate + "]";
    }
}

