/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import java.util.function.DoubleUnaryOperator;
import net.finmath.integration.AbstractRealIntegral;

public class TrapezoidalRealIntegrator
extends AbstractRealIntegral {
    private int numberOfEvaluationPoints;
    private double[] evaluationPoints;

    public TrapezoidalRealIntegrator(double lowerBound, double upperBound, double[] evaluationPoints) {
        super(lowerBound, upperBound);
        this.evaluationPoints = evaluationPoints;
    }

    public TrapezoidalRealIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        super(lowerBound, upperBound);
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
        if (numberOfEvaluationPoints < 2) {
            throw new IllegalArgumentException("Invalid numberOfEvaluationPoints (minumum admissible value is 2).");
        }
    }

    @Override
    public double integrate(DoubleUnaryOperator integrand) {
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double sum = 0.0;
        if (this.evaluationPoints != null) {
            double valueRight;
            double pointRight;
            int i;
            for (i = 0; i < this.evaluationPoints.length && this.evaluationPoints[i] < lowerBound; ++i) {
            }
            double pointLeft = lowerBound;
            double valueLeft = integrand.applyAsDouble(lowerBound);
            while (i < this.evaluationPoints.length && this.evaluationPoints[i] < upperBound) {
                pointRight = this.evaluationPoints[i];
                valueRight = integrand.applyAsDouble(pointRight);
                sum += (valueRight + valueLeft) * (pointRight - pointLeft);
                pointLeft = pointRight;
                valueLeft = valueRight;
                ++i;
            }
            pointRight = upperBound;
            valueRight = integrand.applyAsDouble(pointRight);
            sum += (valueRight + valueLeft) * (pointRight - pointLeft);
            sum /= 2.0;
        } else {
            double intervall = (upperBound - lowerBound) / (double)(this.numberOfEvaluationPoints - 1);
            for (int i = 1; i < this.numberOfEvaluationPoints - 1; ++i) {
                double point = lowerBound + (double)i * intervall;
                sum += integrand.applyAsDouble(point) * intervall;
            }
            sum += (integrand.applyAsDouble(lowerBound) + integrand.applyAsDouble(upperBound)) / 2.0 * intervall;
        }
        return sum;
    }
}

