/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import java.util.function.DoubleUnaryOperator;
import java.util.stream.IntStream;
import net.finmath.integration.AbstractRealIntegral;

public class SimpsonRealIntegrator
extends AbstractRealIntegral {
    private int numberOfEvaluationPoints;
    private boolean useParallelEvaluation = false;

    public SimpsonRealIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints, boolean useParallelEvaluation) {
        super(lowerBound, upperBound);
        if (numberOfEvaluationPoints < 3) {
            throw new IllegalArgumentException("Invalid numberOfEvaluationPoints.");
        }
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
        this.useParallelEvaluation = useParallelEvaluation;
    }

    public SimpsonRealIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this(lowerBound, upperBound, numberOfEvaluationPoints, false);
    }

    @Override
    public double integrate(DoubleUnaryOperator integrand) {
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double range = upperBound - lowerBound;
        int numberOfIntervalls = (int)((double)(this.numberOfEvaluationPoints - 1) / 2.0);
        double fullIntervall = range / (double)numberOfIntervalls;
        double halfIntervall = 0.5 * fullIntervall;
        IntStream intervals = IntStream.range(1, numberOfIntervalls);
        if (this.useParallelEvaluation) {
            intervals = intervals.parallel();
        }
        double sum = intervals.mapToDouble(i -> 2.0 * integrand.applyAsDouble(lowerBound + (double)i * fullIntervall + halfIntervall) + integrand.applyAsDouble(lowerBound + (double)i * fullIntervall)).sum();
        return (integrand.applyAsDouble(lowerBound) + integrand.applyAsDouble(upperBound) + 2.0 * (sum += 2.0 * integrand.applyAsDouble(lowerBound + halfIntervall))) / 6.0 * fullIntervall;
    }
}

