/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.products;

import net.finmath.fouriermethod.products.AbstractProductFourierTransform;
import org.apache.commons.math3.complex.Complex;

public class EuropeanOption
extends AbstractProductFourierTransform {
    private final double maturity;
    private final double strike;
    private final String nameOfUnderliyng;

    public EuropeanOption(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
        this.nameOfUnderliyng = null;
    }

    @Override
    public Complex apply(Complex argument) {
        Complex iargument = argument.multiply(Complex.I);
        Complex exponent = iargument.add(1.0);
        Complex numerator = new Complex(this.strike).pow(exponent);
        Complex denominator = argument.multiply(argument).subtract(iargument);
        return numerator.divide(denominator).negate();
    }

    @Override
    public double getMaturity() {
        return this.maturity;
    }

    @Override
    public double getIntegrationDomainImagLowerBound() {
        return 0.5;
    }

    @Override
    public double getIntegrationDomainImagUpperBound() {
        return 2.5;
    }
}

