/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.struct.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.dongliu.apk.parser.struct.ResourceValue;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.resource.ResourceEntry;
import net.dongliu.apk.parser.struct.resource.ResourcePackage;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.resource.TypeSpec;
import net.dongliu.apk.parser.utils.ResourceLoader;

public class ResourceTable {
    private Map<Short, ResourcePackage> packageMap = new HashMap<Short, ResourcePackage>();
    private StringPool stringPool;
    public static Map<Integer, String> sysStyle = ResourceLoader.loadSystemStyles();

    public void addPackage(ResourcePackage resourcePackage) {
        this.packageMap.put(resourcePackage.getId(), resourcePackage);
    }

    public ResourcePackage getPackage(short id) {
        return this.packageMap.get(id);
    }

    public StringPool getStringPool() {
        return this.stringPool;
    }

    public void setStringPool(StringPool stringPool) {
        this.stringPool = stringPool;
    }

    @Nonnull
    public List<Resource> getResourcesById(long resourceId) {
        short packageId = (short)(resourceId >> 24 & 0xFFL);
        short typeId = (short)(resourceId >> 16 & 0xFFL);
        int entryIndex = (int)(resourceId & 0xFFFFL);
        ResourcePackage resourcePackage = this.getPackage(packageId);
        if (resourcePackage == null) {
            return Collections.emptyList();
        }
        TypeSpec typeSpec = resourcePackage.getTypeSpec(typeId);
        List<Type> types = resourcePackage.getTypes(typeId);
        if (typeSpec == null || types == null) {
            return Collections.emptyList();
        }
        if (!typeSpec.exists(entryIndex)) {
            return Collections.emptyList();
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Type type : types) {
            ResourceValue currentResourceValue;
            ResourceEntry resourceEntry = type.getResourceEntry(entryIndex);
            if (resourceEntry == null || (currentResourceValue = resourceEntry.getValue()) == null || currentResourceValue instanceof ResourceValue.ReferenceResourceValue && resourceId == ((ResourceValue.ReferenceResourceValue)currentResourceValue).getReferenceResourceId()) continue;
            result.add(new Resource(typeSpec, type, resourceEntry));
        }
        return result;
    }

    public static class Resource {
        private TypeSpec typeSpec;
        private Type type;
        private ResourceEntry resourceEntry;

        public Resource(TypeSpec typeSpec, Type type, ResourceEntry resourceEntry) {
            this.typeSpec = typeSpec;
            this.type = type;
            this.resourceEntry = resourceEntry;
        }

        public TypeSpec getTypeSpec() {
            return this.typeSpec;
        }

        public Type getType() {
            return this.type;
        }

        public ResourceEntry getResourceEntry() {
            return this.resourceEntry;
        }
    }
}

