/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.GlEsVersion;
import net.dongliu.apk.parser.bean.IconPath;
import net.dongliu.apk.parser.bean.Permission;
import net.dongliu.apk.parser.bean.UseFeature;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.struct.ResourceValue;
import net.dongliu.apk.parser.struct.resource.ResourceEntry;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.xml.Attribute;
import net.dongliu.apk.parser.struct.xml.Attributes;
import net.dongliu.apk.parser.struct.xml.XmlCData;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeStartTag;

public class ApkMetaTranslator
implements XmlStreamer {
    private String[] tagStack = new String[100];
    private int depth = 0;
    private ApkMeta.Builder apkMetaBuilder = ApkMeta.newBuilder();
    private List<IconPath> iconPaths = Collections.emptyList();
    private ResourceTable resourceTable;
    @Nullable
    private Locale locale;

    public ApkMetaTranslator(ResourceTable resourceTable, @Nullable Locale locale) {
        this.resourceTable = Objects.requireNonNull(resourceTable);
        this.locale = locale;
    }

    @Override
    public void onStartTag(XmlNodeStartTag xmlNodeStartTag) {
        Attributes attributes = xmlNodeStartTag.getAttributes();
        switch (xmlNodeStartTag.getName()) {
            case "application": {
                Attribute iconAttr;
                String label = attributes.getString("label");
                if (label != null) {
                    this.apkMetaBuilder.setLabel(label);
                }
                if ((iconAttr = attributes.get("icon")) == null) break;
                ResourceValue resourceValue = iconAttr.getTypedValue();
                if (resourceValue instanceof ResourceValue.ReferenceResourceValue) {
                    long resourceId = ((ResourceValue.ReferenceResourceValue)resourceValue).getReferenceResourceId();
                    List<ResourceTable.Resource> resources = this.resourceTable.getResourcesById(resourceId);
                    if (resources.isEmpty()) break;
                    ArrayList<IconPath> icons = new ArrayList<IconPath>();
                    boolean hasDefault = false;
                    for (ResourceTable.Resource resource : resources) {
                        Type type = resource.getType();
                        ResourceEntry resourceEntry = resource.getResourceEntry();
                        String path = resourceEntry.toStringValue(this.resourceTable, this.locale);
                        if (type.getDensity() == 0) {
                            hasDefault = true;
                            this.apkMetaBuilder.setIcon(path);
                        }
                        IconPath iconPath = new IconPath(path, type.getDensity());
                        icons.add(iconPath);
                    }
                    if (!hasDefault) {
                        this.apkMetaBuilder.setIcon(((IconPath)icons.get(0)).getPath());
                    }
                    this.iconPaths = icons;
                    break;
                }
                String value = iconAttr.getValue();
                if (value == null) break;
                this.apkMetaBuilder.setIcon(value);
                IconPath iconPath = new IconPath(value, 0);
                this.iconPaths = Collections.singletonList(iconPath);
                break;
            }
            case "manifest": {
                this.apkMetaBuilder.setPackageName(attributes.getString("package"));
                this.apkMetaBuilder.setVersionName(attributes.getString("versionName"));
                this.apkMetaBuilder.setVersionCode(attributes.getLong("versionCode"));
                String installLocation = attributes.getString("installLocation");
                if (installLocation != null) {
                    this.apkMetaBuilder.setInstallLocation(installLocation);
                }
                this.apkMetaBuilder.setCompileSdkVersion(attributes.getString("compileSdkVersion"));
                this.apkMetaBuilder.setCompileSdkVersionCodename(attributes.getString("compileSdkVersionCodename"));
                this.apkMetaBuilder.setPlatformBuildVersionCode(attributes.getString("platformBuildVersionCode"));
                this.apkMetaBuilder.setPlatformBuildVersionName(attributes.getString("platformBuildVersionName"));
                break;
            }
            case "uses-sdk": {
                this.apkMetaBuilder.setMinSdkVersion(attributes.getString("minSdkVersion"));
                this.apkMetaBuilder.setTargetSdkVersion(attributes.getString("targetSdkVersion"));
                this.apkMetaBuilder.setMaxSdkVersion(attributes.getString("maxSdkVersion"));
                break;
            }
            case "supports-screens": {
                this.apkMetaBuilder.setAnyDensity(attributes.getBoolean("anyDensity", false));
                this.apkMetaBuilder.setSmallScreens(attributes.getBoolean("smallScreens", false));
                this.apkMetaBuilder.setNormalScreens(attributes.getBoolean("normalScreens", false));
                this.apkMetaBuilder.setLargeScreens(attributes.getBoolean("largeScreens", false));
                break;
            }
            case "uses-feature": {
                String name = attributes.getString("name");
                boolean required = attributes.getBoolean("required", false);
                if (name != null) {
                    UseFeature useFeature = new UseFeature(name, required);
                    this.apkMetaBuilder.addUsesFeature(useFeature);
                    break;
                }
                Integer gl = attributes.getInt("glEsVersion");
                if (gl == null) break;
                int v = gl;
                GlEsVersion glEsVersion = new GlEsVersion(v >> 16, v & 0xFFFF, required);
                this.apkMetaBuilder.setGlEsVersion(glEsVersion);
                break;
            }
            case "uses-permission": {
                this.apkMetaBuilder.addUsesPermission(attributes.getString("name"));
                break;
            }
            case "permission": {
                Permission permission = new Permission(attributes.getString("name"), attributes.getString("label"), attributes.getString("icon"), attributes.getString("description"), attributes.getString("group"), attributes.getString("android:protectionLevel"));
                this.apkMetaBuilder.addPermissions(permission);
            }
        }
        this.tagStack[this.depth++] = xmlNodeStartTag.getName();
    }

    @Override
    public void onEndTag(XmlNodeEndTag xmlNodeEndTag) {
        --this.depth;
    }

    @Override
    public void onCData(XmlCData xmlCData) {
    }

    @Override
    public void onNamespaceStart(XmlNamespaceStartTag tag) {
    }

    @Override
    public void onNamespaceEnd(XmlNamespaceEndTag tag) {
    }

    @Nonnull
    public ApkMeta getApkMeta() {
        return this.apkMetaBuilder.build();
    }

    @Nonnull
    public List<IconPath> getIconPaths() {
        return this.iconPaths;
    }

    private boolean matchTagPath(String ... tags) {
        if (this.depth != tags.length + 1) {
            return false;
        }
        for (int i = 1; i < this.depth; ++i) {
            if (this.tagStack[i].equals(tags[i - 1])) continue;
            return false;
        }
        return true;
    }

    private boolean matchLastTag(String tag) {
        return this.tagStack[this.depth - 1].endsWith(tag);
    }
}

