/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.parser.CertificateMetas;
import net.dongliu.apk.parser.parser.CertificateParser;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

class BCCertificateParser
extends CertificateParser {
    private static final Provider provider = new BouncyCastleProvider();

    public BCCertificateParser(byte[] data) {
        super(data);
    }

    @Override
    public List<CertificateMeta> parse() throws CertificateException {
        CMSSignedData cmsSignedData;
        try {
            cmsSignedData = new CMSSignedData(this.data);
        }
        catch (CMSException e) {
            throw new CertificateException(e);
        }
        Store certStore = cmsSignedData.getCertificates();
        SignerInformationStore signerInfos = cmsSignedData.getSignerInfos();
        Collection signers = signerInfos.getSigners();
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (SignerInformation signer : signers) {
            Collection matches = certStore.getMatches((Selector)signer.getSID());
            for (X509CertificateHolder holder : matches) {
                certificates.add(new JcaX509CertificateConverter().setProvider(provider).getCertificate(holder));
            }
        }
        return CertificateMetas.from(certificates);
    }
}

