/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.interceptors;

import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import java.util.Objects;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import net.devh.boot.grpc.server.security.interceptors.AbstractAuthenticatingServerCallListener;
import net.devh.boot.grpc.server.security.interceptors.AuthenticatingServerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@GrpcGlobalServerInterceptor
@Order(value=5100)
public class DefaultAuthenticatingServerInterceptor
implements AuthenticatingServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticatingServerInterceptor.class);
    private final AuthenticationManager authenticationManager;
    private final GrpcAuthenticationReader grpcAuthenticationReader;

    @Autowired
    public DefaultAuthenticatingServerInterceptor(AuthenticationManager authenticationManager, GrpcAuthenticationReader authenticationReader) {
        this.authenticationManager = Objects.requireNonNull(authenticationManager, "authenticationManager");
        this.grpcAuthenticationReader = Objects.requireNonNull(authenticationReader, "authenticationReader");
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Authentication authentication;
        try {
            authentication = this.grpcAuthenticationReader.readAuthentication(call, headers);
        }
        catch (AuthenticationException e) {
            log.debug("Failed to read authentication: {}", (Object)e.getMessage());
            throw e;
        }
        if (authentication == null) {
            log.debug("No credentials found: Continuing unauthenticated");
            try {
                return next.startCall(call, headers);
            }
            catch (AccessDeniedException e) {
                throw DefaultAuthenticatingServerInterceptor.newNoCredentialsException(e);
            }
        }
        if (authentication.getDetails() == null && authentication instanceof AbstractAuthenticationToken) {
            ((AbstractAuthenticationToken)authentication).setDetails((Object)call.getAttributes());
        }
        log.debug("Credentials found: Authenticating '{}'", (Object)authentication.getName());
        try {
            authentication = this.authenticationManager.authenticate(authentication);
        }
        catch (AuthenticationException e) {
            log.debug("Authentication request failed: {}", (Object)e.getMessage());
            this.onUnsuccessfulAuthentication(call, headers, e);
            throw e;
        }
        SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
        securityContext.setAuthentication(authentication);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        Context grpcContext = Context.current().withValues(SECURITY_CONTEXT_KEY, (Object)securityContext, AUTHENTICATION_CONTEXT_KEY, (Object)authentication);
        Context previousContext = grpcContext.attach();
        log.debug("Authentication successful: Continuing as {} ({})", (Object)authentication.getName(), (Object)authentication.getAuthorities());
        this.onSuccessfulAuthentication(call, headers, authentication);
        try {
            AuthenticatingServerCallListener authenticatingServerCallListener = new AuthenticatingServerCallListener(next.startCall(call, headers), grpcContext, securityContext);
            return authenticatingServerCallListener;
        }
        catch (AccessDeniedException e) {
            if (authentication instanceof AnonymousAuthenticationToken) {
                throw DefaultAuthenticatingServerInterceptor.newNoCredentialsException(e);
            }
            throw e;
        }
        finally {
            SecurityContextHolder.clearContext();
            grpcContext.detach(previousContext);
            log.debug("startCall - Authentication cleared");
        }
    }

    protected void onSuccessfulAuthentication(ServerCall<?, ?> call, Metadata headers, Authentication authentication) {
    }

    protected void onUnsuccessfulAuthentication(ServerCall<?, ?> call, Metadata headers, AuthenticationException failed) {
    }

    private static AuthenticationException newNoCredentialsException(AccessDeniedException denied) {
        return new BadCredentialsException("No credentials found in the request", (Throwable)denied);
    }

    private static class AuthenticatingServerCallListener<ReqT>
    extends AbstractAuthenticatingServerCallListener<ReqT> {
        private final SecurityContext securityContext;

        public AuthenticatingServerCallListener(ServerCall.Listener<ReqT> delegate, Context grpcContext, SecurityContext securityContext) {
            super(delegate, grpcContext);
            this.securityContext = securityContext;
        }

        @Override
        protected void attachAuthenticationContext() {
            SecurityContextHolder.setContext((SecurityContext)this.securityContext);
        }

        @Override
        protected void detachAuthenticationContext() {
            SecurityContextHolder.clearContext();
        }

        @Override
        public void onHalfClose() {
            try {
                super.onHalfClose();
            }
            catch (AccessDeniedException e) {
                if (this.securityContext.getAuthentication() instanceof AnonymousAuthenticationToken) {
                    throw DefaultAuthenticatingServerInterceptor.newNoCredentialsException(e);
                }
                throw e;
            }
        }
    }
}

