/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.nameresolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfNameResolver
extends NameResolver {
    private static final Logger log = LoggerFactory.getLogger(SelfNameResolver.class);
    private final GrpcServerProperties properties;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    private final SynchronizationContext syncContext;
    @GuardedBy(value="this")
    private NameResolver.Listener listener = null;
    @GuardedBy(value="this")
    private Executor executor = null;
    @GuardedBy(value="this")
    private boolean resolving = false;

    public SelfNameResolver(GrpcServerProperties properties, NameResolver.Args args) {
        this(properties, args, (SharedResourceHolder.Resource<Executor>)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    }

    public SelfNameResolver(GrpcServerProperties properties, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.executorResource = Objects.requireNonNull(executorResource, "executorResource");
        this.syncContext = Objects.requireNonNull(args.getSynchronizationContext(), "syncContext");
    }

    public String getServiceAuthority() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return this.getOwnAddressString("localhost");
        }
    }

    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    public final synchronized void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    @GuardedBy(value="this")
    private void resolve() {
        log.debug("Scheduled self resolve");
        if (this.resolving || this.executor == null) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener));
    }

    public synchronized void shutdown() {
        this.listener = null;
        if (this.executor != null) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
    }

    private SocketAddress getOwnAddress() throws SocketException {
        String address = this.properties.getAddress();
        int port = this.properties.getPort();
        InetSocketAddress target = "*".equals(address) ? new InetSocketAddress(port) : new InetSocketAddress(InetAddresses.forString((String)address), port);
        return target;
    }

    private String getOwnAddressString(String fallback) {
        try {
            return this.getOwnAddress().toString().substring(1);
        }
        catch (SocketException e) {
            return fallback;
        }
    }

    public String toString() {
        return "SelfNameResolver [" + this.getOwnAddressString("<unavailable>") + "]";
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener savedListener;

        Resolve(NameResolver.Listener listener) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
        }

        @Override
        public void run() {
            try {
                this.savedListener.onAddresses((List)ImmutableList.of((Object)new EquivalentAddressGroup(SelfNameResolver.this.getOwnAddress())), Attributes.EMPTY);
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("Failed to resolve own address").withCause((Throwable)e));
            }
            finally {
                SelfNameResolver.this.syncContext.execute(() -> SelfNameResolver.this.resolving = false);
            }
        }
    }
}

