/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={ConsulRegistration.class})
public class GrpcMetadataConsulConfiguration {
    @Autowired(required=false)
    private ConsulRegistration consulRegistration;
    @Autowired
    private GrpcServerProperties grpcProperties;

    @PostConstruct
    public void init() {
        if (this.consulRegistration != null) {
            int port = this.grpcProperties.getPort();
            HashMap<String, String> meta = this.consulRegistration.getService().getMeta();
            if (meta == null) {
                meta = new HashMap<String, String>();
            }
            if (-1 != port) {
                meta.put("gRPC_port", Integer.toString(port));
                this.consulRegistration.getService().setMeta(meta);
            }
        }
    }
}

