/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.error;

import io.grpc.ForwardingServerCallListener;
import io.grpc.ServerCall;
import net.devh.boot.grpc.server.error.GrpcExceptionResponseHandler;

public class GrpcExceptionListener<ReqT, RespT>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
    private final GrpcExceptionResponseHandler exceptionHandler;
    private final ServerCall<ReqT, RespT> serverCall;

    protected GrpcExceptionListener(ServerCall.Listener<ReqT> delegate, ServerCall<ReqT, RespT> serverCall, GrpcExceptionResponseHandler exceptionHandler) {
        super(delegate);
        this.serverCall = serverCall;
        this.exceptionHandler = exceptionHandler;
    }

    public void onMessage(ReqT message) {
        try {
            super.onMessage(message);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleError(this.serverCall, error);
        }
    }

    public void onHalfClose() {
        try {
            super.onHalfClose();
        }
        catch (Throwable error) {
            this.exceptionHandler.handleError(this.serverCall, error);
        }
    }
}

