/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import com.google.common.collect.Lists;
import io.grpc.BindableService;
import io.grpc.Codec;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.devh.springboot.autoconfigure.grpc.server.GlobalServerInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.server.GrpcService;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDefinition;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDiscoverer;
import net.devh.springboot.autoconfigure.grpc.server.codec.GrpcCodec;
import net.devh.springboot.autoconfigure.grpc.server.codec.GrpcCodecDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AnnotationGrpcServiceDiscoverer
implements ApplicationContextAware,
GrpcServiceDiscoverer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationGrpcServiceDiscoverer.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Collection<GrpcServiceDefinition> findGrpcServices() {
        List<String> beanNames = Arrays.asList(this.applicationContext.getBeanNamesForAnnotation(GrpcService.class));
        ArrayList definitions = Lists.newArrayListWithCapacity((int)beanNames.size());
        GlobalServerInterceptorRegistry globalServerInterceptorRegistry = (GlobalServerInterceptorRegistry)this.applicationContext.getBean(GlobalServerInterceptorRegistry.class);
        List<ServerInterceptor> globalInterceptorList = globalServerInterceptorRegistry.getServerInterceptors();
        for (String beanName : beanNames) {
            BindableService bindableService = (BindableService)this.applicationContext.getBean(beanName, BindableService.class);
            ServerServiceDefinition serviceDefinition = bindableService.bindService();
            GrpcService grpcServiceAnnotation = (GrpcService)this.applicationContext.findAnnotationOnBean(beanName, GrpcService.class);
            serviceDefinition = this.bindInterceptors(serviceDefinition, grpcServiceAnnotation, globalInterceptorList);
            definitions.add(new GrpcServiceDefinition(beanName, bindableService.getClass(), serviceDefinition));
            log.debug("Found gRPC service: " + serviceDefinition.getServiceDescriptor().getName() + ", bean: " + beanName + ", class: " + bindableService.getClass().getName());
        }
        return definitions;
    }

    @Override
    public Collection<GrpcCodecDefinition> findGrpcCodec() {
        List<String> beanNames = Arrays.asList(this.applicationContext.getBeanNamesForAnnotation(GrpcCodec.class));
        ArrayList definitions = Lists.newArrayListWithCapacity((int)beanNames.size());
        for (String beanName : beanNames) {
            Codec codec = (Codec)this.applicationContext.getBean(beanName, Codec.class);
            GrpcCodec annotation = (GrpcCodec)this.applicationContext.findAnnotationOnBean(beanName, GrpcCodec.class);
            definitions.add(new GrpcCodecDefinition(codec, annotation.advertised(), annotation.codecType()));
            log.debug("Found custom gRPC custom codec: " + codec.getMessageEncoding() + ", bean: " + beanName + ", class: " + codec.getClass().getName());
        }
        return definitions;
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GrpcService grpcServiceAnnotation, List<ServerInterceptor> globalInterceptorList) {
        ArrayList interceptors = Lists.newArrayList();
        interceptors.addAll(globalInterceptorList);
        for (Class<? extends ServerInterceptor> serverInterceptorClass : grpcServiceAnnotation.interceptors()) {
            ServerInterceptor serverInterceptor;
            if (this.applicationContext.getBeanNamesForType(serverInterceptorClass).length > 0) {
                serverInterceptor = (ServerInterceptor)this.applicationContext.getBean(serverInterceptorClass);
            } else {
                try {
                    serverInterceptor = serverInterceptorClass.newInstance();
                }
                catch (Exception e) {
                    throw new BeanCreationException("Failed to create interceptor instance", (Throwable)e);
                }
            }
            interceptors.add(serverInterceptor);
        }
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, (List)Lists.newArrayList((Iterable)interceptors));
    }
}

