/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.Tracer;

public class TraceServerInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TraceServerInterceptor.class);
    private Tracer tracer;
    private SpanExtractor<Metadata> spanExtractor;

    public TraceServerInterceptor(Tracer tracer, SpanExtractor<Metadata> spanExtractor) {
        this.tracer = tracer;
        this.spanExtractor = spanExtractor;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Span span = this.spanExtractor.joinTrace((Object)headers);
        this.tracer.continueSpan(span);
        final Span grpcSpan = this.tracer.createSpan("grpc:" + call.getMethodDescriptor().getFullMethodName());
        ServerCall.Listener original = next.startCall(call, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(original){

            public void onComplete() {
                TraceServerInterceptor.this.tracer.close(grpcSpan);
                super.onComplete();
            }
        };
    }
}

