/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.common.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;

public final class InterceptorOrder {
    public static final int ORDER_FIRST = Integer.MIN_VALUE;
    public static final int ORDER_GLOBAL_EXCEPTION_HANDLING = 0;
    public static final int ORDER_TRACING_METRICS = 2500;
    public static final int ORDER_SECURITY_EXCEPTION_HANDLING = 5000;
    public static final int ORDER_SECURITY_AUTHENTICATION = 5100;
    public static final int ORDER_SECURITY_AUTHORISATION = 5200;
    public static final int ORDER_LAST = Integer.MAX_VALUE;

    public static Comparator<Object> beanFactoryAwareOrderComparator(ApplicationContext context, Class<?> beanType) {
        BiMap beans = HashBiMap.create((Map)context.getBeansOfType(beanType)).inverse();
        return OrderComparator.INSTANCE.withSourceProvider(arg_0 -> InterceptorOrder.lambda$beanFactoryAwareOrderComparator$1((Map)beans, context, arg_0));
    }

    private InterceptorOrder() {
    }

    private static /* synthetic */ Object lambda$beanFactoryAwareOrderComparator$1(Map beans, ApplicationContext context, Object bean) {
        Order order;
        Integer priority = AnnotationAwareOrderComparator.INSTANCE.getPriority(bean);
        if (priority != null) {
            return () -> priority;
        }
        String beanName = (String)beans.get(bean);
        if (beanName != null && (order = (Order)context.findAnnotationOnBean(beanName, Order.class)) != null) {
            return () -> ((Order)order).value();
        }
        return null;
    }
}

