/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.collect.ImmutableList;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class StaticNameResolver
extends NameResolver {
    private final String authority;
    private final NameResolver.ResolutionResult result;

    public StaticNameResolver(String authority, EquivalentAddressGroup target) {
        this(authority, (Collection<EquivalentAddressGroup>)ImmutableList.of((Object)Objects.requireNonNull(target, "target")));
    }

    public StaticNameResolver(String authority, Collection<EquivalentAddressGroup> targets) {
        this.authority = Objects.requireNonNull(authority, "authority");
        if (Objects.requireNonNull(targets, "targets").isEmpty()) {
            throw new IllegalArgumentException("Must have at least one target");
        }
        this.result = NameResolver.ResolutionResult.newBuilder().setAddresses((List)ImmutableList.copyOf(targets)).build();
    }

    public StaticNameResolver(String authority, NameResolver.ResolutionResult result) {
        this.authority = Objects.requireNonNull(authority, "authority");
        this.result = Objects.requireNonNull(result, "result");
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(NameResolver.Listener2 listener) {
        listener.onResult(this.result);
    }

    public void refresh() {
    }

    public void shutdown() {
    }

    public String toString() {
        return "StaticNameResolver [authority=" + this.authority + ", result=" + this.result + "]";
    }
}

