/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import io.grpc.Metadata;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;

class MetadataInjector
implements SpanInjector<Metadata> {
    private static final String HEADER_DELIMITER = "-";

    MetadataInjector() {
    }

    public void inject(Span span, Metadata carrier) {
        this.setIdMetadata(carrier, "X-B3-TraceId", span.getTraceId());
        this.setIdMetadata(carrier, "X-B3-SpanId", span.getSpanId());
        this.setMetadata(carrier, "X-Span-Name", span.getName());
        this.setMetadata(carrier, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setMetadata(carrier, "X-Process-Id", span.getProcessId() == null ? "null" : span.getProcessId());
        Long parentId = this.getParentId(span);
        if (parentId != null) {
            this.setIdMetadata(carrier, "X-B3-ParentSpanId", parentId);
        }
        for (Map.Entry entry : span.baggageItems()) {
            this.setMetadata(carrier, this.prefixedKey((String)entry.getKey()), (String)entry.getValue());
        }
    }

    private String prefixedKey(String key) {
        if (key.startsWith("baggage-")) {
            return key;
        }
        return "baggage-" + key;
    }

    private void setMetadata(Metadata metadata, String name, String value) {
        metadata.put(Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
    }

    private void setIdMetadata(Metadata metadata, String name, Long value) {
        if (value != null) {
            this.setMetadata(metadata, name, Span.idToHex((long)value));
        }
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? (Long)span.getParents().get(0) : null;
    }
}

