/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.NettyChannelBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientNameResolver;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientResolverFactory;
import net.devh.springboot.autoconfigure.grpc.client.GlobalClientInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelProperties;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.context.event.EventListener;

public class DiscoveryClientChannelFactory
implements GrpcChannelFactory {
    private final GrpcChannelsProperties properties;
    private final DiscoveryClient client;
    private final LoadBalancer.Factory loadBalancerFactory;
    private final GlobalClientInterceptorRegistry globalClientInterceptorRegistry;
    private HeartbeatMonitor monitor = new HeartbeatMonitor();
    private List<DiscoveryClientNameResolver> discoveryClientNameResolvers = Lists.newArrayList();

    public DiscoveryClientChannelFactory(GrpcChannelsProperties properties, DiscoveryClient client, LoadBalancer.Factory loadBalancerFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        this.properties = properties;
        this.client = client;
        this.loadBalancerFactory = loadBalancerFactory;
        this.globalClientInterceptorRegistry = globalClientInterceptorRegistry;
    }

    public void addDiscoveryClientNameResolver(DiscoveryClientNameResolver discoveryClientNameResolver) {
        this.discoveryClientNameResolvers.add(discoveryClientNameResolver);
    }

    @EventListener(value={HeartbeatEvent.class})
    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            for (DiscoveryClientNameResolver discoveryClientNameResolver : this.discoveryClientNameResolvers) {
                discoveryClientNameResolver.refresh();
            }
        }
    }

    @Override
    public Channel createChannel(String name) {
        return this.createChannel(name, null);
    }

    @Override
    public Channel createChannel(String name, List<ClientInterceptor> interceptors) {
        GrpcChannelProperties channelProperties = this.properties.getChannel(name);
        NettyChannelBuilder builder = ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory)).nameResolverFactory((NameResolver.Factory)new DiscoveryClientResolverFactory(this.client, this))).usePlaintext(this.properties.getChannel(name).isPlaintext());
        if (channelProperties.isEnableKeepAlive()) {
            builder.keepAliveWithoutCalls(channelProperties.isKeepAliveWithoutCalls()).keepAliveTime(channelProperties.getKeepAliveTime(), TimeUnit.SECONDS).keepAliveTimeout(channelProperties.getKeepAliveTimeout(), TimeUnit.SECONDS);
        }
        ManagedChannel channel = builder.build();
        List<ClientInterceptor> globalInterceptorList = this.globalClientInterceptorRegistry.getClientInterceptors();
        HashSet interceptorSet = Sets.newHashSet();
        if (globalInterceptorList != null && !globalInterceptorList.isEmpty()) {
            interceptorSet.addAll(globalInterceptorList);
        }
        if (interceptors != null && !interceptors.isEmpty()) {
            interceptorSet.addAll(interceptors);
        }
        return ClientInterceptors.intercept((Channel)channel, (List)Lists.newArrayList((Iterable)interceptorSet));
    }
}

