/*
 * Decompiled with CFR 0.152.
 */
package net.dathoang.cqrs.commandbus.spring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.dathoang.cqrs.commandbus.autoscan.AutoScanHandlerFactory;
import net.dathoang.cqrs.commandbus.autoscan.BeanFactory;
import net.dathoang.cqrs.commandbus.autoscan.HandlerScan;
import org.springframework.context.ApplicationContext;

public class SpringAutoScanHandlerFactory
extends AutoScanHandlerFactory {
    private ApplicationContext context;

    public SpringAutoScanHandlerFactory(final ApplicationContext context) {
        super(new BeanFactory(){

            public <R> R createBean(Class<R> beanClass) {
                context.getAutowireCapableBeanFactory().autowireBean(beanClass);
                return (R)context.getAutowireCapableBeanFactory().createBean(beanClass);
            }
        });
        this.context = context;
        Set<String> packagesToScan = this.getPackagesToScanConfig();
        packagesToScan.forEach(arg_0 -> ((SpringAutoScanHandlerFactory)this).scanAndRegisterHandlers(arg_0));
    }

    private Set<String> getPackagesToScanConfig() {
        HashSet<String> packagesToScan = new HashSet<String>();
        Map springApplicationInstances = this.context.getBeansWithAnnotation(HandlerScan.class);
        for (Object appInstance : springApplicationInstances.values()) {
            HandlerScan scanAnnotation = appInstance.getClass().getAnnotation(HandlerScan.class);
            if (scanAnnotation == null) continue;
            packagesToScan.addAll(Arrays.asList(scanAnnotation.basePackages()));
        }
        return packagesToScan;
    }
}

