/*
 * Decompiled with CFR 0.152.
 */
package net.codebox.readableregex;

import net.codebox.readableregex.RegExBuilder;
import net.codebox.readableregex.Token;

public class Quantifier {
    private final String baseText;
    private final String suffix;

    private Quantifier(String baseText, String suffix) {
        this.baseText = baseText;
        this.suffix = suffix;
    }

    public Token of(Token ... tokens) {
        if (tokens.length == 1) {
            return new Token(tokens[0], this);
        }
        return this.of(new Token(RegExBuilder.build(tokens), true, null));
    }

    public Token of(String text) {
        return this.of(Token.text(text));
    }

    public Quantifier greedy() {
        return new Quantifier(this.baseText, "");
    }

    public Quantifier lazy() {
        return new Quantifier(this.baseText, "?");
    }

    public Quantifier possessive() {
        return new Quantifier(this.baseText, "+");
    }

    public String toString() {
        return Quantifier.appendSuffix(this.baseText, this.suffix);
    }

    private static String appendSuffix(String txt, String suffix) {
        return txt + (suffix == null ? "" : suffix);
    }

    public static Quantifier oneOrMore() {
        return new Quantifier("+", "");
    }

    public static Quantifier zeroOrOne() {
        return new Quantifier("?", "");
    }

    public static Quantifier zeroOrMore() {
        return new Quantifier("*", "");
    }

    public static Quantifier between(int from, int to) {
        if (from < 0 || to < 0) {
            throw new IllegalArgumentException("A negative value was passed to the between() method, values must be >= 0");
        }
        if (from > to) {
            throw new IllegalArgumentException(String.format("The 'from' argument value of %d was larger than the 'to' argument value of %d", new Object[0]));
        }
        return new Quantifier("{" + from + "," + to + "}", "");
    }

    public static Quantifier exactly(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("A negative value was passed to the exactly() method, value must be >= 0");
        }
        return new Quantifier("{" + count + "}", "");
    }

    public static Quantifier atLeast(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("A negative value was passed to the atLeast() method, value must be >= 0");
        }
        return new Quantifier("{" + count + ",}", "");
    }
}

