/*
 * Decompiled with CFR 0.152.
 */
package net.cafeto.queryserialize;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import net.cafeto.entitycopy.DeepCopy;
import net.cafeto.queryserialize.CriteriaQuery;

public class QuerySerialize
implements Serializable {
    private static final long serialVersionUID = -6758243782217905627L;
    private CriteriaQuery criteria;
    private Integer offset = 0;
    private Integer limit = 0;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private DeepCopy deepCopy;

    public CriteriaQuery getCriteria() {
        return this.criteria;
    }

    public void setCriteria(CriteriaQuery criteria) {
        this.criteria = criteria;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public DeepCopy getDeepCopy() {
        return this.deepCopy;
    }

    public void setDeepCopy(DeepCopy deepCopy) {
        this.deepCopy = deepCopy;
    }

    public List<?> getResultList(EntityManager entityManager) throws IllegalStateException {
        if (this.criteria == null) {
            throw new NullPointerException("Criteria is null");
        }
        Query query = entityManager.createQuery(this.criteria.toJPQL());
        for (Map.Entry<String, Object> param : this.getParameters().entrySet()) {
            query.setParameter(param.getKey(), param.getValue());
        }
        if (this.offset != null && this.offset > 0) {
            query.setFirstResult(this.offset.intValue());
        }
        if (this.limit != null && this.limit > 0) {
            query.setMaxResults(this.limit.intValue());
        }
        return query.getResultList();
    }

    public Object getSingleResult(EntityManager entityManager) throws NoResultException, NonUniqueResultException, IllegalStateException {
        if (this.criteria == null) {
            throw new NullPointerException("Criteria is null");
        }
        Query query = entityManager.createQuery(this.criteria.toJPQL());
        for (Map.Entry<String, Object> param : this.getParameters().entrySet()) {
            query.setParameter(param.getKey(), param.getValue());
        }
        if (this.offset != null && this.offset > 0) {
            query.setFirstResult(this.offset.intValue());
        }
        if (this.limit != null && this.limit > 0) {
            query.setMaxResults(this.limit.intValue());
        }
        return query.getSingleResult();
    }

    public Long getCountResult(EntityManager entityManager) throws NoResultException, NonUniqueResultException, IllegalStateException {
        if (this.criteria == null) {
            throw new NullPointerException("Criteria is null");
        }
        Query query = entityManager.createQuery(this.criteria.toJPQLCount());
        for (Map.Entry<String, Object> param : this.getParameters().entrySet()) {
            query.setParameter(param.getKey(), param.getValue());
        }
        return (Long)query.getSingleResult();
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }
}

