/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import java.lang.reflect.Field;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class FieldConstant
implements StackManipulation {
    private static final MethodDescription.InDefinedShape GET_DECLARED_FIELD = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredField").and(ElementMatchers.takesArguments(String.class)))).getOnly();
    private final FieldDescription.InDefinedShape fieldDescription;

    public FieldConstant(FieldDescription.InDefinedShape fieldDescription) {
        this.fieldDescription = fieldDescription;
    }

    public StackManipulation cached() {
        return new Cached(this);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return new StackManipulation.Compound(ClassConstant.of(this.fieldDescription.getDeclaringType()), new TextConstant(this.fieldDescription.getInternalName()), MethodInvocation.invoke(GET_DECLARED_FIELD)).apply(methodVisitor, implementationContext);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.fieldDescription.equals(((FieldConstant)other).fieldDescription);
    }

    public int hashCode() {
        return this.fieldDescription.hashCode();
    }

    public String toString() {
        return "FieldConstant{fieldDescription=" + this.fieldDescription + '}';
    }

    protected static class Cached
    implements StackManipulation {
        private final StackManipulation fieldConstant;

        public Cached(StackManipulation fieldConstant) {
            this.fieldConstant = fieldConstant;
        }

        @Override
        public boolean isValid() {
            return this.fieldConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.fieldConstant, new TypeDescription.ForLoadedType(Field.class))).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldConstant.equals(((Cached)other).fieldConstant);
        }

        public int hashCode() {
            return this.fieldConstant.hashCode();
        }

        public String toString() {
            return "FieldConstant.Cached{fieldConstant=" + this.fieldConstant + '}';
        }
    }
}

