/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.utility.RandomString;

public interface ClassInjector {
    public static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN = null;
    public static final boolean DEFAULT_FORBID_EXISTING = false;

    public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> var1);

    public static class UsingInstrumentation
    implements ClassInjector {
        private static final String PREFIX = "jar";
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Instrumentation instrumentation;
        private final Target target;
        private final File folder;
        private final RandomString randomString;

        public static ClassInjector of(File folder, Target target, Instrumentation instrumentation) {
            return new UsingInstrumentation(folder, target, instrumentation, new RandomString());
        }

        protected UsingInstrumentation(File folder, Target target, Instrumentation instrumentation, RandomString randomString) {
            this.folder = folder;
            this.target = target;
            this.instrumentation = instrumentation;
            this.randomString = randomString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            File jarFile = new File(this.folder, String.format("%s%s.jar", PREFIX, this.randomString.nextString()));
            try {
                if (!jarFile.createNewFile()) {
                    throw new IllegalStateException("Cannot create file " + jarFile);
                }
                JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(jarFile));
                try {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION));
                        jarOutputStream.write(entry.getValue());
                    }
                }
                finally {
                    jarOutputStream.close();
                }
                this.target.inject(this.instrumentation, new JarFile(jarFile));
                HashMap loaded = new HashMap();
                for (TypeDescription typeDescription : types.keySet()) {
                    loaded.put(typeDescription, Class.forName(typeDescription.getName(), false, ClassLoader.getSystemClassLoader()));
                }
                return loaded;
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot write jar file to disk", exception);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Cannot load injected class", exception);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingInstrumentation that = (UsingInstrumentation)other;
            return this.folder.equals(that.folder) && this.instrumentation.equals(that.instrumentation) && this.target == that.target && this.randomString.equals(that.randomString);
        }

        public int hashCode() {
            int result = this.instrumentation.hashCode();
            result = 31 * result + this.target.hashCode();
            result = 31 * result + this.folder.hashCode();
            result = 31 * result + this.randomString.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingInstrumentation{instrumentation=" + this.instrumentation + ", target=" + (Object)((Object)this.target) + ", folder=" + this.folder + ", randomString=" + this.randomString + '}';
        }

        public static enum Target {
            BOOTSTRAP{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
                }
            }
            ,
            SYSTEM{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToSystemClassLoaderSearch(jarFile);
                }
            };


            protected abstract void inject(Instrumentation var1, JarFile var2);

            public String toString() {
                return "ClassInjector.UsingInstrumentation.Target." + this.name();
            }
        }
    }

    public static class UsingReflection
    implements ClassInjector {
        private static final Dispatcher.Initializable DISPATCHER = Dispatcher.Resolved.make();
        private final ClassLoader classLoader;
        private final ProtectionDomain protectionDomain;
        private final PackageDefinitionStrategy packageDefinitionStrategy;
        private final boolean forbidExisting;

        public UsingReflection(ClassLoader classLoader) {
            this(classLoader, DEFAULT_PROTECTION_DOMAIN);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            this(classLoader, protectionDomain, PackageDefinitionStrategy.Trivial.INSTANCE, false);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
            }
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.packageDefinitionStrategy = packageDefinitionStrategy;
            this.forbidExisting = forbidExisting;
        }

        public static ClassInjector ofSystemClassLoader() {
            return new UsingReflection(ClassLoader.getSystemClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            ClassLoader classLoader = this.classLoader;
            synchronized (classLoader) {
                HashMap loadedTypes = new HashMap();
                for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                    String typeName = entry.getKey().getName();
                    Dispatcher dispatcher = DISPATCHER.initialize();
                    Class<?> type = dispatcher.findClass(this.classLoader, typeName);
                    if (type == null) {
                        String packageName;
                        PackageDefinitionStrategy.Definition definition;
                        int packageIndex = typeName.lastIndexOf(46);
                        if (packageIndex != -1 && (definition = this.packageDefinitionStrategy.define(this.classLoader, packageName = typeName.substring(0, packageIndex), typeName)).isDefined()) {
                            Package definedPackage = dispatcher.getPackage(this.classLoader, packageName);
                            if (definedPackage == null) {
                                dispatcher.definePackage(this.classLoader, packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                            } else if (!definition.isCompatibleTo(definedPackage)) {
                                throw new SecurityException("Sealing violation for package " + packageName);
                            }
                        }
                        type = dispatcher.defineClass(this.classLoader, typeName, entry.getValue(), this.protectionDomain);
                    } else if (this.forbidExisting) {
                        throw new IllegalStateException("Cannot inject already loaded type: " + type);
                    }
                    loadedTypes.put(entry.getKey(), type);
                }
                return loadedTypes;
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            UsingReflection that = (UsingReflection)other;
            return this.classLoader.equals(that.classLoader) && this.forbidExisting == that.forbidExisting && this.packageDefinitionStrategy.equals(that.packageDefinitionStrategy) && !(this.protectionDomain == null ? that.protectionDomain != null : !this.protectionDomain.equals(that.protectionDomain));
        }

        public int hashCode() {
            int result = this.classLoader.hashCode();
            result = 31 * result + (this.protectionDomain != null ? this.protectionDomain.hashCode() : 0);
            result = 31 * result + (this.forbidExisting ? 1 : 0);
            result = 31 * result + this.packageDefinitionStrategy.hashCode();
            return result;
        }

        public String toString() {
            return "ClassInjector.UsingReflection{classLoader=" + this.classLoader + ", protectionDomain=" + this.protectionDomain + ", packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", forbidExisting=" + this.forbidExisting + '}';
        }

        protected static interface Dispatcher {
            public Class<?> findClass(ClassLoader var1, String var2);

            public Class<?> defineClass(ClassLoader var1, String var2, byte[] var3, ProtectionDomain var4);

            public Package getPackage(ClassLoader var1, String var2);

            public Package definePackage(ClassLoader var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, URL var9);

            public static class Faulty
            implements Initializable {
                private final Exception exception;

                protected Faulty(Exception exception) {
                    this.exception = exception;
                }

                @Override
                public Dispatcher initialize() {
                    throw new IllegalStateException("Error locating class loader API", this.exception);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Faulty)other).exception);
                }

                public int hashCode() {
                    return this.exception.hashCode();
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.Dispatcher.Faulty{exception=" + this.exception + '}';
                }
            }

            public static class Resolved
            implements Dispatcher,
            Initializable {
                private static final Object STATIC_MEMBER = null;
                private final Method findLoadedClass;
                private final Method defineClass;
                private final Method getPackage;
                private final Method definePackage;
                private final Field theUnsafe;
                private final Method defineClassUnsafe;

                protected Resolved(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Field theUnsafe, Method defineClassUnsafe) {
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                    this.theUnsafe = theUnsafe;
                    this.defineClassUnsafe = defineClassUnsafe;
                }

                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                protected static Initializable make() {
                    Method defineClass;
                    Field theUnsafe;
                    try {
                        Class<?> unsafe = Class.forName("sun.misc.Unsafe");
                        theUnsafe = unsafe.getDeclaredField("theUnsafe");
                        defineClass = unsafe.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                    }
                    catch (Throwable ignored) {
                        theUnsafe = null;
                        defineClass = null;
                    }
                    try {
                        return new Resolved(ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class), ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), ClassLoader.class.getDeclaredMethod("getPackage", String.class), ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class), theUnsafe, defineClass);
                    }
                    catch (Exception exception) {
                        return new Faulty(exception);
                    }
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke((Object)classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke((Object)classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED", "REC_CATCH_EXCEPTION"}, justification="Privilege is explicit user responsibility")
                public Dispatcher initialize() {
                    try {
                        this.findLoadedClass.setAccessible(true);
                        this.defineClass.setAccessible(true);
                        this.getPackage.setAccessible(true);
                        this.definePackage.setAccessible(true);
                        return this;
                    }
                    catch (RuntimeException exception) {
                        if (this.theUnsafe == null) {
                            throw exception;
                        }
                        try {
                            this.theUnsafe.setAccessible(true);
                            return new UnsafeDispatcher(this.theUnsafe.get(STATIC_MEMBER), this.defineClassUnsafe);
                        }
                        catch (Exception ignored) {
                            throw exception;
                        }
                    }
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Resolved resolved = (Resolved)other;
                    return this.findLoadedClass.equals(resolved.findLoadedClass) && this.defineClass.equals(resolved.defineClass) && this.getPackage.equals(resolved.getPackage) && this.definePackage.equals(resolved.definePackage) && this.theUnsafe.equals(resolved.theUnsafe) && this.defineClassUnsafe.equals(resolved.defineClassUnsafe);
                }

                public int hashCode() {
                    int result = this.findLoadedClass.hashCode();
                    result = 31 * result + this.defineClass.hashCode();
                    result = 31 * result + this.getPackage.hashCode();
                    result = 31 * result + this.definePackage.hashCode();
                    result = 31 * result + this.theUnsafe.hashCode();
                    result = 31 * result + this.defineClassUnsafe.hashCode();
                    return result;
                }

                public String toString() {
                    return "ClassInjector.UsingReflection.Dispatcher.Resolved{findLoadedClass=" + this.findLoadedClass + ", defineClass=" + this.defineClass + ", getPackage=" + this.getPackage + ", definePackage=" + this.definePackage + ", theUnsafe=" + this.theUnsafe + ", defineClassUnsafe=" + this.defineClassUnsafe + '}';
                }

                protected static class UnsafeDispatcher
                implements Dispatcher {
                    private static final Class<?> UNDEFINED = null;
                    private final Object unsafe;
                    private final Method defineClass;

                    protected UnsafeDispatcher(Object unsafe, Method defineClass) {
                        this.unsafe = unsafe;
                        this.defineClass = defineClass;
                    }

                    @Override
                    public Class<?> findClass(ClassLoader classLoader, String name) {
                        try {
                            return classLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException ignored) {
                            return UNDEFINED;
                        }
                    }

                    @Override
                    public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                        try {
                            return (Class)this.defineClass.invoke(this.unsafe, name, binaryRepresentation, 0, binaryRepresentation.length, classLoader, protectionDomain);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Could not access com.sun.Unsafe#defineClass", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking com.sun.Unsafe#defineClass", exception.getCause());
                        }
                    }

                    @Override
                    public Package getPackage(ClassLoader classLoader, String name) {
                        throw new UnsupportedOperationException("Cannot get package using unsafe injection dispatcher: " + name);
                    }

                    @Override
                    public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                        throw new UnsupportedOperationException("Cannot define package using unsafe injection dispatcher: " + name);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        UnsafeDispatcher that = (UnsafeDispatcher)object;
                        return this.unsafe.equals(that.unsafe) && this.defineClass.equals(that.defineClass);
                    }

                    public int hashCode() {
                        int result = this.unsafe.hashCode();
                        result = 31 * result + this.defineClass.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "ClassInjector.UsingReflection.Dispatcher.Resolved.UnsafeDispatcher{unsafe=" + this.unsafe + ", defineClass=" + this.defineClass + '}';
                    }
                }
            }

            public static interface Initializable {
                public Dispatcher initialize();
            }
        }
    }
}

