/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent.builder;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.Map;
import net.bytebuddy.agent.builder.AgentBuilder;

public interface ResettableClassFileTransformer
extends ClassFileTransformer {
    public Reset reset(Instrumentation var1, AgentBuilder.RedefinitionStrategy var2);

    public Reset reset(Instrumentation var1, AgentBuilder.RedefinitionStrategy var2, AgentBuilder.RedefinitionStrategy.BatchAllocator var3);

    public Reset reset(Instrumentation var1, AgentBuilder.RedefinitionStrategy var2, AgentBuilder.RedefinitionStrategy.BatchAllocator var3, AgentBuilder.RedefinitionStrategy.Listener var4);

    public static interface Reset {
        public boolean isApplied();

        public Map<Class<?>, Throwable> getErrors();

        public static class WithErrors
        implements Reset {
            private final Map<Class<?>, Throwable> failures;

            protected WithErrors(Map<Class<?>, Throwable> failures) {
                this.failures = failures;
            }

            public static Reset ofPotentiallyErroneous(Map<Class<?>, Throwable> failures) {
                return failures.isEmpty() ? Simple.ACTIVE : new WithErrors(failures);
            }

            @Override
            public boolean isApplied() {
                return true;
            }

            @Override
            public Map<Class<?>, Throwable> getErrors() {
                return this.failures;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WithErrors that = (WithErrors)object;
                return this.failures.equals(that.failures);
            }

            public int hashCode() {
                return this.failures.hashCode();
            }

            public String toString() {
                return "ResettableClassFileTransformer.Reset.WithErrors{failures=" + this.failures + '}';
            }
        }

        public static enum Simple implements Reset
        {
            ACTIVE(true),
            INACTIVE(false);

            private final boolean alive;

            private Simple(boolean alive) {
                this.alive = alive;
            }

            @Override
            public boolean isApplied() {
                return this.alive;
            }

            @Override
            public Map<Class<?>, Throwable> getErrors() {
                return Collections.emptyMap();
            }

            public String toString() {
                return "ResettableClassFileTransformer.Reset.Simple." + this.name();
            }
        }
    }

    public static abstract class AbstractBase
    implements ResettableClassFileTransformer {
        @Override
        public Reset reset(Instrumentation instrumentation, AgentBuilder.RedefinitionStrategy redefinitionStrategy) {
            return this.reset(instrumentation, redefinitionStrategy, AgentBuilder.RedefinitionStrategy.BatchAllocator.ForTotal.INSTANCE);
        }

        @Override
        public Reset reset(Instrumentation instrumentation, AgentBuilder.RedefinitionStrategy redefinitionStrategy, AgentBuilder.RedefinitionStrategy.BatchAllocator redefinitionBatchAllocator) {
            return this.reset(instrumentation, redefinitionStrategy, redefinitionBatchAllocator, AgentBuilder.RedefinitionStrategy.Listener.NoOp.INSTANCE);
        }
    }
}

