/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Type;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class FieldAccessor
implements Implementation {
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected FieldAccessor(Assigner assigner, Assigner.Typing typing) {
        this.assigner = assigner;
        this.typing = typing;
    }

    public static OwnerTypeLocatable ofField(String name) {
        return new ForNamedField(Assigner.DEFAULT, Assigner.Typing.STATIC, name);
    }

    public static OwnerTypeLocatable ofBeanProperty() {
        return FieldAccessor.of(FieldNameExtractor.ForBeanProperty.INSTANCE);
    }

    public static OwnerTypeLocatable of(FieldNameExtractor fieldNameExtractor) {
        return new ForUnnamedField(Assigner.DEFAULT, Assigner.Typing.STATIC, fieldNameExtractor);
    }

    protected ByteCodeAppender.Size applyGetter(MethodVisitor methodVisitor, Implementation.Context implementationContext, FieldDescription fieldDescription, MethodDescription methodDescription) {
        StackManipulation stackManipulation = this.assigner.assign(fieldDescription.getType(), methodDescription.getReturnType(), this.typing);
        if (!stackManipulation.isValid()) {
            throw new IllegalStateException("Getter type of " + methodDescription + " is not compatible with " + fieldDescription);
        }
        return this.apply(methodVisitor, implementationContext, fieldDescription, methodDescription, new StackManipulation.Compound(FieldAccess.forField(fieldDescription).getter(), stackManipulation));
    }

    protected ByteCodeAppender.Size applySetter(MethodVisitor methodVisitor, Implementation.Context implementationContext, FieldDescription fieldDescription, MethodDescription methodDescription) {
        StackManipulation stackManipulation = this.assigner.assign(((ParameterDescription)methodDescription.getParameters().get(0)).getType(), fieldDescription.getType(), this.typing);
        if (!stackManipulation.isValid()) {
            throw new IllegalStateException("Setter type of " + methodDescription + " is not compatible with " + fieldDescription);
        }
        if (fieldDescription.isFinal()) {
            throw new IllegalArgumentException("Cannot apply setter on final field " + fieldDescription);
        }
        return this.apply(methodVisitor, implementationContext, fieldDescription, methodDescription, new StackManipulation.Compound(MethodVariableAccess.of(fieldDescription.getType().asErasure()).loadOffset(((ParameterDescription)methodDescription.getParameters().get(0)).getOffset()), stackManipulation, FieldAccess.forField(fieldDescription).putter()));
    }

    private ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, FieldDescription fieldDescription, MethodDescription methodDescription, StackManipulation fieldAccess) {
        if (methodDescription.isStatic() && !fieldDescription.isStatic()) {
            throw new IllegalArgumentException("Cannot call instance field " + fieldDescription + " from static method " + methodDescription);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), fieldAccess, MethodReturn.of(methodDescription.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), methodDescription.getStackSize());
    }

    protected abstract String getFieldName(MethodDescription var1);

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.typing == ((FieldAccessor)other).typing && this.assigner.equals(((FieldAccessor)other).assigner);
    }

    public int hashCode() {
        return 31 * this.assigner.hashCode() + this.typing.hashCode();
    }

    protected class Appender
    implements ByteCodeAppender {
        private final FieldLocator fieldLocator;

        protected Appender(FieldLocator fieldLocator) {
            this.fieldLocator = fieldLocator;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (ElementMatchers.isConstructor().matches(instrumentedMethod)) {
                throw new IllegalArgumentException("Constructors cannot define beans: " + instrumentedMethod);
            }
            FieldLocator.Resolution resolution = this.fieldLocator.locate(FieldAccessor.this.getFieldName(instrumentedMethod));
            if (!resolution.isResolved() || instrumentedMethod.isStatic() && !resolution.getField().isStatic()) {
                throw new IllegalStateException("Cannot locate accessible field for " + instrumentedMethod);
            }
            if (ElementMatchers.takesArguments(0).and(ElementMatchers.not(ElementMatchers.returns(Void.TYPE))).matches(instrumentedMethod)) {
                return FieldAccessor.this.applyGetter(methodVisitor, implementationContext, resolution.getField(), instrumentedMethod);
            }
            if (ElementMatchers.takesArguments(1).and(ElementMatchers.returns(Void.TYPE)).matches(instrumentedMethod)) {
                return FieldAccessor.this.applySetter(methodVisitor, implementationContext, resolution.getField(), instrumentedMethod);
            }
            throw new IllegalArgumentException("Method " + implementationContext + " is no bean property");
        }

        private FieldAccessor getFieldAccessor() {
            return FieldAccessor.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldLocator.equals(((Appender)other).fieldLocator) && FieldAccessor.this.equals(((Appender)other).getFieldAccessor());
        }

        public int hashCode() {
            return 31 * FieldAccessor.this.hashCode() + this.fieldLocator.hashCode();
        }

        public String toString() {
            return "FieldAccessor.Appender{fieldLocator=" + this.fieldLocator + "fieldAccessor=" + FieldAccessor.this + '}';
        }
    }

    protected static class ForNamedField
    extends FieldAccessor
    implements OwnerTypeLocatable {
        private final String fieldName;
        private final FieldLocator.Factory fieldLocatorFactory;

        protected ForNamedField(Assigner assigner, Assigner.Typing typing, String fieldName) {
            super(assigner, typing);
            this.fieldName = fieldName;
            this.fieldLocatorFactory = FieldLocator.ForClassHierarchy.Factory.INSTANCE;
        }

        private ForNamedField(Assigner assigner, Assigner.Typing typing, String fieldName, FieldLocator.Factory fieldLocatorFactory) {
            super(assigner, typing);
            this.fieldName = fieldName;
            this.fieldLocatorFactory = fieldLocatorFactory;
        }

        @Override
        public AssignerConfigurable in(FieldLocator.Factory factory) {
            return new ForNamedField(this.assigner, this.typing, this.fieldName, factory);
        }

        @Override
        public AssignerConfigurable in(Class<?> type) {
            return this.in(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            return typeDescription.represents((Type)((Object)TargetType.class)) ? this.in(FieldLocator.ForClassHierarchy.Factory.INSTANCE) : this.in(new FieldLocator.ForExactType.Factory(typeDescription));
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForNamedField(assigner, typing, this.fieldName, this.fieldLocatorFactory);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()));
        }

        @Override
        protected String getFieldName(MethodDescription targetMethod) {
            return this.fieldName;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            ForNamedField that = (ForNamedField)other;
            return this.fieldLocatorFactory.equals(that.fieldLocatorFactory) && this.fieldName.equals(that.fieldName);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.fieldLocatorFactory.hashCode();
            return result;
        }

        public String toString() {
            return "FieldAccessor.ForNamedField{assigner=" + this.assigner + ", fieldName='" + this.fieldName + '\'' + ", typing=" + (Object)((Object)this.typing) + ", fieldLocatorFactory=" + this.fieldLocatorFactory + '}';
        }
    }

    protected static class ForUnnamedField
    extends FieldAccessor
    implements OwnerTypeLocatable {
        private final FieldLocator.Factory fieldLocatorFactory;
        private final FieldNameExtractor fieldNameExtractor;

        protected ForUnnamedField(Assigner assigner, Assigner.Typing typing, FieldNameExtractor fieldNameExtractor) {
            this(assigner, typing, fieldNameExtractor, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
        }

        protected ForUnnamedField(Assigner assigner, Assigner.Typing typing, FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory) {
            super(assigner, typing);
            this.fieldNameExtractor = fieldNameExtractor;
            this.fieldLocatorFactory = fieldLocatorFactory;
        }

        @Override
        public AssignerConfigurable in(FieldLocator.Factory factory) {
            return new ForUnnamedField(this.assigner, this.typing, this.fieldNameExtractor, factory);
        }

        @Override
        public AssignerConfigurable in(Class<?> type) {
            return this.in(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            return typeDescription.represents((Type)((Object)TargetType.class)) ? this.in(FieldLocator.ForClassHierarchy.Factory.INSTANCE) : this.in(new FieldLocator.ForExactType.Factory(typeDescription));
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForUnnamedField(assigner, typing, this.fieldNameExtractor, this.fieldLocatorFactory);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()));
        }

        @Override
        protected String getFieldName(MethodDescription targetMethod) {
            return this.fieldNameExtractor.fieldNameFor(targetMethod);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.fieldNameExtractor.equals(((ForUnnamedField)other).fieldNameExtractor) && this.fieldLocatorFactory.equals(((ForUnnamedField)other).fieldLocatorFactory);
        }

        @Override
        public int hashCode() {
            return 31 * (31 * super.hashCode() + this.fieldLocatorFactory.hashCode()) + this.fieldNameExtractor.hashCode();
        }

        public String toString() {
            return "FieldAccessor.ForUnnamedField{assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + ", fieldLocatorFactory=" + this.fieldLocatorFactory + ", fieldNameExtractor=" + this.fieldNameExtractor + '}';
        }
    }

    public static interface OwnerTypeLocatable
    extends AssignerConfigurable {
        public AssignerConfigurable in(Class<?> var1);

        public AssignerConfigurable in(TypeDescription var1);

        public AssignerConfigurable in(FieldLocator.Factory var1);
    }

    public static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1, Assigner.Typing var2);
    }

    public static interface FieldNameExtractor {
        public String fieldNameFor(MethodDescription var1);

        public static enum ForBeanProperty implements FieldNameExtractor
        {
            INSTANCE;


            @Override
            public String fieldNameFor(MethodDescription methodDescription) {
                int crop;
                String name = methodDescription.getInternalName();
                if (name.startsWith("get") || name.startsWith("set")) {
                    crop = 3;
                } else if (name.startsWith("is")) {
                    crop = 2;
                } else {
                    throw new IllegalArgumentException(methodDescription + " does not follow Java bean naming conventions");
                }
                name = name.substring(crop);
                if (name.length() == 0) {
                    throw new IllegalArgumentException(methodDescription + " does not specify a bean name");
                }
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }

            public String toString() {
                return "FieldAccessor.FieldNameExtractor.ForBeanProperty." + this.name();
            }
        }
    }
}

