/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.Throw;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class ExceptionMethod
implements Implementation,
ByteCodeAppender {
    private final TypeDescription throwableType;
    private final ConstructionDelegate constructionDelegate;

    public ExceptionMethod(TypeDescription throwableType, ConstructionDelegate constructionDelegate) {
        this.throwableType = throwableType;
        this.constructionDelegate = constructionDelegate;
    }

    public static Implementation throwing(Class<? extends Throwable> exceptionType) {
        return ExceptionMethod.throwing(new TypeDescription.ForLoadedType(exceptionType));
    }

    public static Implementation throwing(TypeDescription exceptionType) {
        if (!exceptionType.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(exceptionType + " does not extend throwable");
        }
        return new ExceptionMethod(exceptionType, new ConstructionDelegate.ForDefaultConstructor(exceptionType));
    }

    public static Implementation throwing(Class<? extends Throwable> exceptionType, String message) {
        return ExceptionMethod.throwing(new TypeDescription.ForLoadedType(exceptionType), message);
    }

    public static Implementation throwing(TypeDescription exceptionType, String message) {
        if (!exceptionType.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(exceptionType + " does not extend throwable");
        }
        return new ExceptionMethod(exceptionType, new ConstructionDelegate.ForStringConstructor(exceptionType, message));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return this;
    }

    @Override
    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        StackManipulation.Size stackSize = new StackManipulation.Compound(this.constructionDelegate.make(), Throw.INSTANCE).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.constructionDelegate.equals(((ExceptionMethod)other).constructionDelegate) && this.throwableType.equals(((ExceptionMethod)other).throwableType);
    }

    public int hashCode() {
        return 31 * this.throwableType.hashCode() + this.constructionDelegate.hashCode();
    }

    public String toString() {
        return "ExceptionMethod{throwableType=" + this.throwableType + ", constructionDelegate=" + this.constructionDelegate + '}';
    }

    public static interface ConstructionDelegate {
        public StackManipulation make();

        public static class ForStringConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;
            private final String message;

            public ForStringConstructor(TypeDescription exceptionType, String message) {
                this.exceptionType = exceptionType;
                this.targetConstructor = (MethodDescription)((MethodList)exceptionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(String.class)))).getOnly();
                this.message = message;
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.of(this.exceptionType), Duplication.SINGLE, new TextConstant(this.message), MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.message.equals(((ForStringConstructor)other).message) && this.exceptionType.equals(((ForStringConstructor)other).exceptionType);
            }

            public int hashCode() {
                return 31 * this.exceptionType.hashCode() + this.message.hashCode();
            }

            public String toString() {
                return "ExceptionMethod.ConstructionDelegate.ForStringConstructor{exceptionType=" + this.exceptionType + ", targetConstructor=" + this.targetConstructor + ", message='" + this.message + '\'' + '}';
            }
        }

        public static class ForDefaultConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;

            public ForDefaultConstructor(TypeDescription exceptionType) {
                this.exceptionType = exceptionType;
                this.targetConstructor = (MethodDescription)((MethodList)exceptionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly();
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.of(this.exceptionType), Duplication.SINGLE, MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.exceptionType.equals(((ForDefaultConstructor)other).exceptionType);
            }

            public int hashCode() {
                return this.exceptionType.hashCode();
            }

            public String toString() {
                return "ExceptionMethod.ConstructionDelegate.ForDefaultConstructor{exceptionType=" + this.exceptionType + ", targetConstructor=" + this.targetConstructor + '}';
            }
        }
    }
}

