/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatchers;

public interface Transformer<T> {
    public T transform(TypeDescription var1, T var2);

    public static class Compound<S>
    implements Transformer<S> {
        private final List<? extends Transformer<S>> transformers;

        public Compound(Transformer<S> ... transformer) {
            this(Arrays.asList(transformer));
        }

        public Compound(List<? extends Transformer<S>> transformers) {
            this.transformers = transformers;
        }

        @Override
        public S transform(TypeDescription instrumentedType, S target) {
            for (Transformer<S> transformer : this.transformers) {
                target = transformer.transform(instrumentedType, target);
            }
            return target;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.transformers.equals(((Compound)other).transformers);
        }

        public int hashCode() {
            return this.transformers.hashCode();
        }

        public String toString() {
            return "Transformer.Compound{transformers=" + this.transformers + '}';
        }
    }

    public static class ForMethod
    implements Transformer<MethodDescription> {
        private final Transformer<MethodDescription.Token> transformer;

        public ForMethod(Transformer<MethodDescription.Token> transformer) {
            this.transformer = transformer;
        }

        public static Transformer<MethodDescription> withModifiers(ModifierContributor.ForMethod ... modifierTransformer) {
            return new ForMethod(new MethodModifierTransformer(Arrays.asList(modifierTransformer)));
        }

        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            return new TransformedMethod(instrumentedType, methodDescription.getDeclaringType(), this.transformer.transform(instrumentedType, (MethodDescription.Token)methodDescription.asToken(ElementMatchers.none())), (MethodDescription.InDefinedShape)methodDescription.asDefined());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.transformer.equals(((ForMethod)other).transformer);
        }

        public int hashCode() {
            return this.transformer.hashCode();
        }

        public String toString() {
            return "Transformer.ForMethod{transformer=" + this.transformer + '}';
        }

        protected static class TransformedMethod
        extends MethodDescription.AbstractBase {
            private final TypeDescription instrumentedType;
            private final TypeDefinition declaringType;
            private final MethodDescription.Token token;
            private final MethodDescription.InDefinedShape methodDescription;

            protected TransformedMethod(TypeDescription instrumentedType, TypeDefinition declaringType, MethodDescription.Token token, MethodDescription.InDefinedShape methodDescription) {
                this.instrumentedType = instrumentedType;
                this.declaringType = declaringType;
                this.token = token;
                this.methodDescription = methodDescription;
            }

            @Override
            public TypeList.Generic getTypeVariables() {
                return new TypeList.Generic.ForDetachedTypes.OfTypeVariables(this, this.token.getTypeVariableTokens(), new AttachmentVisitor());
            }

            @Override
            public TypeDescription.Generic getReturnType() {
                return this.token.getReturnType().accept(new AttachmentVisitor());
            }

            @Override
            public ParameterList<?> getParameters() {
                return new TransformedParameterList();
            }

            @Override
            public TypeList.Generic getExceptionTypes() {
                return new TypeList.Generic.ForDetachedTypes(this.token.getExceptionTypes(), new AttachmentVisitor());
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return this.token.getAnnotations();
            }

            @Override
            public String getInternalName() {
                return this.token.getName();
            }

            @Override
            public TypeDefinition getDeclaringType() {
                return this.declaringType;
            }

            @Override
            public int getModifiers() {
                return this.token.getModifiers();
            }

            @Override
            public Object getDefaultValue() {
                return this.token.getDefaultValue();
            }

            @Override
            public MethodDescription.InDefinedShape asDefined() {
                return this.methodDescription;
            }

            @Override
            public TypeDescription.Generic getReceiverType() {
                TypeDescription.Generic receiverType = this.token.getReceiverType();
                return receiverType == null ? TypeDescription.Generic.UNDEFINED : receiverType.accept(new AttachmentVisitor());
            }

            protected class AttachmentVisitor
            extends TypeDescription.Generic.Visitor.Substitutor.WithoutTypeSubstitution {
                protected AttachmentVisitor() {
                }

                @Override
                public TypeDescription.Generic onTypeVariable(TypeDescription.Generic typeVariable) {
                    TypeDescription.Generic attached;
                    TypeList.Generic candidates = (TypeList.Generic)TransformedMethod.this.getTypeVariables().filter(ElementMatchers.named(typeVariable.getSymbol()));
                    TypeDescription.Generic generic = attached = candidates.isEmpty() ? TransformedMethod.this.instrumentedType.findVariable(typeVariable.getSymbol()) : (TypeDescription.Generic)candidates.getOnly();
                    if (attached == null) {
                        throw new IllegalArgumentException("Cannot attach undefined variable: " + typeVariable);
                    }
                    return new TypeDescription.Generic.OfTypeVariable.WithAnnotationOverlay(attached, typeVariable.getDeclaredAnnotations());
                }

                public int hashCode() {
                    return TransformedMethod.this.hashCode();
                }

                public boolean equals(Object other) {
                    return this == other || other instanceof AttachmentVisitor && ((AttachmentVisitor)other).getOuter().equals(TransformedMethod.this);
                }

                private TransformedMethod getOuter() {
                    return TransformedMethod.this;
                }

                public String toString() {
                    return "Transformer.ForMethod.TransformedMethod.AttachmentVisitor{outer=" + TransformedMethod.this + '}';
                }
            }

            protected class TransformedParameter
            extends ParameterDescription.AbstractBase {
                private final int index;
                private final ParameterDescription.Token parameterToken;

                protected TransformedParameter(int index, ParameterDescription.Token parameterToken) {
                    this.index = index;
                    this.parameterToken = parameterToken;
                }

                @Override
                public TypeDescription.Generic getType() {
                    return this.parameterToken.getType().accept(new AttachmentVisitor());
                }

                @Override
                public MethodDescription getDeclaringMethod() {
                    return TransformedMethod.this;
                }

                @Override
                public int getIndex() {
                    return this.index;
                }

                @Override
                public boolean isNamed() {
                    return this.parameterToken.getName() != null;
                }

                @Override
                public boolean hasModifiers() {
                    return this.parameterToken.getModifiers() != null;
                }

                @Override
                public String getName() {
                    return this.isNamed() ? this.parameterToken.getName() : super.getName();
                }

                @Override
                public int getModifiers() {
                    return this.hasModifiers() ? this.parameterToken.getModifiers().intValue() : super.getModifiers();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.parameterToken.getAnnotations();
                }

                @Override
                public ParameterDescription.InDefinedShape asDefined() {
                    return (ParameterDescription.InDefinedShape)TransformedMethod.this.methodDescription.getParameters().get(this.index);
                }
            }

            protected class TransformedParameterList
            extends ParameterList.AbstractBase<ParameterDescription> {
                protected TransformedParameterList() {
                }

                @Override
                public ParameterDescription get(int index) {
                    return new TransformedParameter(index, (ParameterDescription.Token)TransformedMethod.this.token.getParameterTokens().get(index));
                }

                @Override
                public int size() {
                    return TransformedMethod.this.token.getParameterTokens().size();
                }
            }
        }

        protected static class MethodModifierTransformer
        implements Transformer<MethodDescription.Token> {
            private final List<? extends ModifierContributor.ForMethod> modifierContributors;

            public MethodModifierTransformer(List<? extends ModifierContributor.ForMethod> modifierContributors) {
                this.modifierContributors = modifierContributors;
            }

            @Override
            public MethodDescription.Token transform(TypeDescription instrumentedType, MethodDescription.Token target) {
                return new MethodDescription.Token(target.getName(), ModifierContributor.Resolver.of(this.modifierContributors).resolve(target.getModifiers()), target.getTypeVariableTokens(), target.getReturnType(), target.getParameterTokens(), target.getExceptionTypes(), target.getAnnotations(), target.getDefaultValue(), target.getReceiverType());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.modifierContributors.equals(((MethodModifierTransformer)other).modifierContributors);
            }

            public int hashCode() {
                return this.modifierContributors.hashCode();
            }

            public String toString() {
                return "Transformer.ForMethod.MethodModifierTransformer{modifierContributors=" + this.modifierContributors + '}';
            }
        }
    }

    public static class ForField
    implements Transformer<FieldDescription> {
        private final Transformer<FieldDescription.Token> transformer;

        public ForField(Transformer<FieldDescription.Token> transformer) {
            this.transformer = transformer;
        }

        public static Transformer<FieldDescription> withModifiers(ModifierContributor.ForField ... modifierContributor) {
            return new ForField(new FieldModifierTransformer(Arrays.asList(modifierContributor)));
        }

        @Override
        public FieldDescription transform(TypeDescription instrumentedType, FieldDescription fieldDescription) {
            return new TransformedField(instrumentedType, fieldDescription.getDeclaringType(), this.transformer.transform(instrumentedType, (FieldDescription.Token)fieldDescription.asToken(ElementMatchers.none())), (FieldDescription.InDefinedShape)fieldDescription.asDefined());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.transformer.equals(((ForField)other).transformer);
        }

        public int hashCode() {
            return this.transformer.hashCode();
        }

        public String toString() {
            return "Transformer.ForField{transformer=" + this.transformer + '}';
        }

        protected static class TransformedField
        extends FieldDescription.AbstractBase {
            private final TypeDescription instrumentedType;
            private final TypeDefinition declaringType;
            private final FieldDescription.Token token;
            private final FieldDescription.InDefinedShape fieldDescription;

            protected TransformedField(TypeDescription instrumentedType, TypeDefinition declaringType, FieldDescription.Token token, FieldDescription.InDefinedShape fieldDescription) {
                this.instrumentedType = instrumentedType;
                this.declaringType = declaringType;
                this.token = token;
                this.fieldDescription = fieldDescription;
            }

            @Override
            public TypeDescription.Generic getType() {
                return this.token.getType().accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this.instrumentedType));
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return this.token.getAnnotations();
            }

            @Override
            public TypeDefinition getDeclaringType() {
                return this.declaringType;
            }

            @Override
            public int getModifiers() {
                return this.token.getModifiers();
            }

            @Override
            public FieldDescription.InDefinedShape asDefined() {
                return this.fieldDescription;
            }

            @Override
            public String getName() {
                return this.token.getName();
            }
        }

        protected static class FieldModifierTransformer
        implements Transformer<FieldDescription.Token> {
            private final List<? extends ModifierContributor.ForField> modifierContributors;

            public FieldModifierTransformer(List<? extends ModifierContributor.ForField> modifierContributors) {
                this.modifierContributors = modifierContributors;
            }

            @Override
            public FieldDescription.Token transform(TypeDescription instrumentedType, FieldDescription.Token target) {
                return new FieldDescription.Token(target.getName(), ModifierContributor.Resolver.of(this.modifierContributors).resolve(target.getModifiers()), target.getType(), target.getAnnotations());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.modifierContributors.equals(((FieldModifierTransformer)other).modifierContributors);
            }

            public int hashCode() {
                return this.modifierContributors.hashCode();
            }

            public String toString() {
                return "Transformer.ForField.FieldModifierTransformer{modifierContributors=" + this.modifierContributors + '}';
            }
        }
    }

    public static enum NoOp implements Transformer<Object>
    {
        INSTANCE;


        public static <T> Transformer<T> make() {
            return INSTANCE;
        }

        @Override
        public Object transform(TypeDescription instrumentedType, Object target) {
            return target;
        }

        public String toString() {
            return "Transformer.NoOp." + this.name();
        }
    }
}

