/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.utility.StreamDrainer;

public interface ClassFileLocator
extends Closeable {
    public static final String CLASS_FILE_EXTENSION = ".class";

    public Resolution locate(String var1) throws IOException;

    public static class Compound
    implements ClassFileLocator,
    Closeable {
        private final List<? extends ClassFileLocator> classFileLocators;

        public Compound(ClassFileLocator ... classFileLocator) {
            this(Arrays.asList(classFileLocator));
        }

        public Compound(List<? extends ClassFileLocator> classFileLocators) {
            this.classFileLocators = classFileLocators;
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocators) {
                Resolution resolution = classFileLocator.locate(typeName);
                if (!resolution.isResolved()) continue;
                return resolution;
            }
            return new Resolution.Illegal(typeName);
        }

        @Override
        public void close() throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocators) {
                classFileLocator.close();
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classFileLocators.equals(((Compound)other).classFileLocators);
        }

        public int hashCode() {
            return this.classFileLocators.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.Compound{classFileLocators=" + this.classFileLocators + '}';
        }
    }

    public static class AgentBased
    implements ClassFileLocator {
        private static final String INSTALLER_TYPE = "net.bytebuddy.agent.Installer";
        private static final String INSTRUMENTATION_FIELD = "instrumentation";
        private static final Object STATIC_FIELD = null;
        private final Instrumentation instrumentation;
        private final ClassLoadingDelegate classLoadingDelegate;

        public AgentBased(Instrumentation instrumentation, ClassLoader classLoader) {
            this(instrumentation, ClassLoadingDelegate.Default.of(classLoader));
        }

        public AgentBased(Instrumentation instrumentation, ClassLoadingDelegate classLoadingDelegate) {
            if (!instrumentation.isRetransformClassesSupported()) {
                throw new IllegalArgumentException(instrumentation + " does not support retransformation");
            }
            this.instrumentation = instrumentation;
            this.classLoadingDelegate = classLoadingDelegate;
        }

        public static ClassFileLocator fromInstalledAgent(ClassLoader classLoader) {
            try {
                Instrumentation instrumentation = (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getDeclaredField(INSTRUMENTATION_FIELD).get(STATIC_FIELD);
                if (instrumentation == null) {
                    throw new IllegalStateException("The Byte Buddy agent is not installed");
                }
                return new AgentBased(instrumentation, classLoader);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
            }
        }

        public static ClassFileLocator of(Instrumentation instrumentation, Class<?> type) {
            return new AgentBased(instrumentation, ClassLoadingDelegate.Explicit.of(type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) {
            Resolution resolution;
            ExtractionClassFileTransformer classFileTransformer = new ExtractionClassFileTransformer(this.classLoadingDelegate.getClassLoader(), typeName);
            this.instrumentation.addTransformer(classFileTransformer, true);
            try {
                this.instrumentation.retransformClasses(this.classLoadingDelegate.locate(typeName));
                byte[] binaryRepresentation = classFileTransformer.getBinaryRepresentation();
                resolution = binaryRepresentation == null ? new Resolution.Illegal(typeName) : new Resolution.Explicit(binaryRepresentation);
                this.instrumentation.removeTransformer(classFileTransformer);
            }
            catch (Throwable throwable) {
                try {
                    this.instrumentation.removeTransformer(classFileTransformer);
                    throw throwable;
                }
                catch (RuntimeException exception) {
                    throw exception;
                }
                catch (Exception ignored) {
                    return new Resolution.Illegal(typeName);
                }
            }
            return resolution;
        }

        @Override
        public void close() throws IOException {
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoadingDelegate.equals(((AgentBased)other).classLoadingDelegate) && this.instrumentation.equals(((AgentBased)other).instrumentation);
        }

        public int hashCode() {
            return 31 * this.instrumentation.hashCode() + this.classLoadingDelegate.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.AgentBased{instrumentation=" + this.instrumentation + ", classLoadingDelegate=" + this.classLoadingDelegate + '}';
        }

        protected static class ExtractionClassFileTransformer
        implements ClassFileTransformer {
            private static final byte[] DO_NOT_TRANSFORM = null;
            private final ClassLoader classLoader;
            private final String typeName;
            @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The array is not to be modified by contract")
            private volatile byte[] binaryRepresentation;

            protected ExtractionClassFileTransformer(ClassLoader classLoader, String typeName) {
                this.classLoader = classLoader;
                this.typeName = typeName;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="The array is not to be modified by contract")
            public byte[] transform(ClassLoader classLoader, String internalName, Class<?> redefinedType, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                if (internalName != null && this.isChild(classLoader) && this.typeName.equals(internalName.replace('/', '.'))) {
                    this.binaryRepresentation = binaryRepresentation;
                }
                return DO_NOT_TRANSFORM;
            }

            private boolean isChild(ClassLoader classLoader) {
                if (this.classLoader == null) {
                    return true;
                }
                do {
                    if (classLoader != this.classLoader) continue;
                    return true;
                } while ((classLoader = classLoader.getParent()) != null);
                return false;
            }

            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The array is not to be modified by contract")
            protected byte[] getBinaryRepresentation() {
                return this.binaryRepresentation;
            }

            public String toString() {
                return "ClassFileLocator.AgentBased.ExtractionClassFileTransformer{classLoader=" + this.classLoader + ", typeName=" + this.typeName + ", binaryRepresentation=" + (this.binaryRepresentation != null ? "<" + this.binaryRepresentation.length + " bytes>" : "null") + '}';
            }
        }

        public static interface ClassLoadingDelegate {
            public Class<?> locate(String var1) throws ClassNotFoundException;

            public ClassLoader getClassLoader();

            public static class Explicit
            implements ClassLoadingDelegate {
                private final ClassLoadingDelegate fallbackDelegate;
                private final Map<String, Class<?>> types;

                public Explicit(ClassLoader classLoader, Collection<? extends Class<?>> types) {
                    this(Default.of(classLoader), types);
                }

                public Explicit(ClassLoadingDelegate fallbackDelegate, Collection<? extends Class<?>> types) {
                    this.fallbackDelegate = fallbackDelegate;
                    this.types = new HashMap();
                    for (Class<?> type : types) {
                        this.types.put(TypeDescription.ForLoadedType.getName(type), type);
                    }
                }

                public static ClassLoadingDelegate of(Class<?> type) {
                    return new Explicit(type.getClassLoader(), Collections.singleton(type));
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Class<?> type = this.types.get(name);
                    return type == null ? this.fallbackDelegate.locate(name) : type;
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.fallbackDelegate.getClassLoader();
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fallbackDelegate.equals(((Explicit)other).fallbackDelegate) && this.types.equals(((Explicit)other).types);
                }

                public int hashCode() {
                    int result = this.fallbackDelegate.hashCode();
                    result = 31 * result + this.types.hashCode();
                    return result;
                }

                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.Explicit{fallbackDelegate=" + this.fallbackDelegate + ", types=" + this.types + '}';
                }
            }

            public static class ForDelegatingClassLoader
            extends Default {
                private static final String DELEGATING_CLASS_LOADER_NAME = "sun.reflect.DelegatingClassLoader";
                private static final int ONLY = 0;
                private static final Dispatcher.Initializable DISPATCHER;

                protected ForDelegatingClassLoader(ClassLoader classLoader) {
                    super(classLoader);
                }

                protected static boolean isDelegating(ClassLoader classLoader) {
                    return classLoader != null && classLoader.getClass().getName().equals(DELEGATING_CLASS_LOADER_NAME);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Vector<Class<?>> classes;
                    try {
                        classes = DISPATCHER.initialize().extract(this.classLoader);
                    }
                    catch (RuntimeException ignored) {
                        return super.locate(name);
                    }
                    if (classes.size() != 1) {
                        return super.locate(name);
                    }
                    Class<?> type = classes.get(0);
                    return TypeDescription.ForLoadedType.getName(type).equals(name) ? type : super.locate(name);
                }

                @Override
                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader{classLoader=" + this.classLoader + '}';
                }

                static {
                    Dispatcher.Initializable dispatcher;
                    try {
                        dispatcher = new Dispatcher.Resolved(ClassLoader.class.getDeclaredField("classes"));
                    }
                    catch (NoSuchFieldException exception) {
                        dispatcher = new Dispatcher.Unresolved(exception);
                    }
                    DISPATCHER = dispatcher;
                }

                protected static interface Dispatcher {
                    public Vector<Class<?>> extract(ClassLoader var1);

                    public static class Unresolved
                    implements Initializable {
                        private final Exception exception;

                        public Unresolved(Exception exception) {
                            this.exception = exception;
                        }

                        @Override
                        public Dispatcher initialize() {
                            throw new IllegalStateException("Could not locate classes vector", this.exception);
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Unresolved)other).exception);
                        }

                        public int hashCode() {
                            return this.exception.hashCode();
                        }

                        public String toString() {
                            return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader.Dispatcher.Unresolved{exception=" + this.exception + '}';
                        }
                    }

                    public static class Resolved
                    implements Dispatcher,
                    Initializable,
                    PrivilegedAction<Dispatcher> {
                        private final Field field;

                        public Resolved(Field field) {
                            this.field = field;
                        }

                        @Override
                        public Dispatcher initialize() {
                            return AccessController.doPrivileged(this);
                        }

                        @Override
                        public Vector<Class<?>> extract(ClassLoader classLoader) {
                            try {
                                return (Vector)this.field.get(classLoader);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access field", exception);
                            }
                        }

                        @Override
                        public Dispatcher run() {
                            this.field.setAccessible(true);
                            return this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.field.equals(((Resolved)other).field);
                        }

                        public int hashCode() {
                            return this.field.hashCode();
                        }

                        public String toString() {
                            return "ClassFileLocator.AgentBased.ClassLoadingDelegate.ForDelegatingClassLoader.Dispatcher.Resolved{field=" + this.field + '}';
                        }
                    }

                    public static interface Initializable {
                        public Dispatcher initialize();
                    }
                }
            }

            public static class Default
            implements ClassLoadingDelegate {
                protected final ClassLoader classLoader;

                protected Default(ClassLoader classLoader) {
                    this.classLoader = classLoader;
                }

                public static ClassLoadingDelegate of(ClassLoader classLoader) {
                    return ForDelegatingClassLoader.isDelegating(classLoader) ? new ForDelegatingClassLoader(classLoader) : new Default(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    return this.classLoader.loadClass(name);
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.classLoader;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Default aDefault = (Default)other;
                    return !(this.classLoader == null ? aDefault.classLoader != null : !this.classLoader.equals(aDefault.classLoader));
                }

                public int hashCode() {
                    return this.classLoader != null ? this.classLoader.hashCode() : 0;
                }

                public String toString() {
                    return "ClassFileLocator.AgentBased.ClassLoadingDelegate.Default{classLoader=" + this.classLoader + '}';
                }
            }
        }
    }

    public static class ForFolder
    implements ClassFileLocator {
        private final File folder;

        public ForFolder(File folder) {
            this.folder = folder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            File file = new File(this.folder, typeName.replace('.', File.separatorChar) + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (file.exists()) {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                    return explicit;
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            return new Resolution.Illegal(typeName);
        }

        @Override
        public void close() throws IOException {
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ForFolder && this.folder.equals(((ForFolder)other).folder);
        }

        public int hashCode() {
            return this.folder.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForFolder{folder=" + this.folder + '}';
        }
    }

    public static class ForModuleFile
    implements ClassFileLocator {
        private static final String JMOD_FILE_EXTENSION = ".jmod";
        private static final List<String> BOOT_LOCATIONS = Arrays.asList("jmods", "../jmods");
        private final ZipFile zipFile;

        public ForModuleFile(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        public static ClassFileLocator ofBootPath() throws IOException {
            String javaHome = System.getProperty("java.home").replace('\\', '/');
            File bootPath = null;
            for (String location : BOOT_LOCATIONS) {
                File candidate = new File(javaHome, location);
                if (!candidate.isDirectory()) continue;
                bootPath = candidate;
                break;
            }
            if (bootPath == null) {
                throw new IllegalStateException("Boot modules do not exist in " + javaHome + " for any of " + BOOT_LOCATIONS);
            }
            return ForModuleFile.ofBootPath(bootPath);
        }

        public static ClassFileLocator ofBootPath(File bootPath) throws IOException {
            File[] module = bootPath.listFiles();
            if (module == null) {
                return NoOp.INSTANCE;
            }
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>(module.length);
            for (File aModule : module) {
                if (!aModule.isFile()) continue;
                classFileLocators.add(ForModuleFile.of(aModule));
            }
            return new Compound(classFileLocators);
        }

        public static ClassFileLocator ofModulePath() throws IOException {
            String modulePath = System.getProperty("jdk.module.path");
            return modulePath == null ? NoOp.INSTANCE : ForModuleFile.ofModulePath(modulePath);
        }

        public static ClassFileLocator ofModulePath(String modulePath) throws IOException {
            return ForModuleFile.ofModulePath(modulePath, System.getProperty("user.dir"));
        }

        public static ClassFileLocator ofModulePath(String modulePath, String baseFolder) throws IOException {
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (String element : Pattern.compile(System.getProperty("path.separator"), 16).split(modulePath)) {
                File file = new File(baseFolder, element);
                if (file.isDirectory()) {
                    File[] module = file.listFiles();
                    if (module == null) continue;
                    for (File aModule : module) {
                        if (aModule.isDirectory()) {
                            classFileLocators.add(new ForFolder(aModule));
                            continue;
                        }
                        if (!aModule.isFile()) continue;
                        classFileLocators.add(aModule.getName().endsWith(JMOD_FILE_EXTENSION) ? ForModuleFile.of(aModule) : ForJarFile.of(aModule));
                    }
                    continue;
                }
                if (!file.isFile()) continue;
                classFileLocators.add(file.getName().endsWith(JMOD_FILE_EXTENSION) ? ForModuleFile.of(file) : ForJarFile.of(file));
            }
            return new Compound(classFileLocators);
        }

        public static ClassFileLocator of(File file) throws IOException {
            return new ForModuleFile(new ZipFile(file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            ZipEntry zipEntry = this.zipFile.getEntry("classes/" + typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (zipEntry == null) {
                return new Resolution.Illegal(typeName);
            }
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            try {
                Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                return explicit;
            }
            finally {
                inputStream.close();
            }
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ForModuleFile that = (ForModuleFile)object;
            return this.zipFile.equals(that.zipFile);
        }

        public int hashCode() {
            return this.zipFile.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForModuleFile{zipFile=" + this.zipFile + '}';
        }
    }

    public static class ForJarFile
    implements ClassFileLocator {
        private static final List<String> RUNTIME_LOCATIONS = Arrays.asList("lib/rt.jar", "../lib/rt.jar", "../Classes/classes.jar");
        private final JarFile jarFile;

        public ForJarFile(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        public static ClassFileLocator of(File file) throws IOException {
            return new ForJarFile(new JarFile(file));
        }

        public static ClassFileLocator ofClassPath() throws IOException {
            return ForJarFile.ofClassPath(System.getProperty("java.class.path"));
        }

        public static ClassFileLocator ofClassPath(String classPath) throws IOException {
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (String element : Pattern.compile(System.getProperty("path.separator"), 16).split(classPath)) {
                File file = new File(element);
                if (file.isDirectory()) {
                    classFileLocators.add(new ForFolder(file));
                    continue;
                }
                if (!file.isFile()) continue;
                classFileLocators.add(ForJarFile.of(file));
            }
            return new Compound(classFileLocators);
        }

        public static ClassFileLocator ofRuntimeJar() throws IOException {
            String javaHome = System.getProperty("java.home").replace('\\', '/');
            File runtimeJar = null;
            for (String location : RUNTIME_LOCATIONS) {
                File candidate = new File(javaHome, location);
                if (!candidate.isFile()) continue;
                runtimeJar = candidate;
                break;
            }
            if (runtimeJar == null) {
                throw new IllegalStateException("Runtime jar does not exist in " + javaHome + " for any of " + RUNTIME_LOCATIONS);
            }
            return ForJarFile.of(runtimeJar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            ZipEntry zipEntry = this.jarFile.getEntry(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (zipEntry == null) {
                return new Resolution.Illegal(typeName);
            }
            InputStream inputStream = this.jarFile.getInputStream(zipEntry);
            try {
                Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                return explicit;
            }
            finally {
                inputStream.close();
            }
        }

        @Override
        public void close() throws IOException {
            this.jarFile.close();
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ForJarFile && this.jarFile.equals(((ForJarFile)other).jarFile);
        }

        public int hashCode() {
            return this.jarFile.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForJarFile{jarFile=" + this.jarFile + '}';
        }
    }

    public static class ForClassLoader
    implements ClassFileLocator {
        private final ClassLoader classLoader;

        protected ForClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public static ClassFileLocator ofClassPath() {
            return new ForClassLoader(ClassLoader.getSystemClassLoader());
        }

        public static ClassFileLocator of(ClassLoader classLoader) {
            return new ForClassLoader(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
        }

        public static Resolution read(Class<?> type) {
            try {
                ClassLoader classLoader = type.getClassLoader();
                return ForClassLoader.locate(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader, TypeDescription.ForLoadedType.getName(type));
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot read class file for " + type, exception);
            }
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            return ForClassLoader.locate(this.classLoader, typeName);
        }

        @Override
        public void close() throws IOException {
            if (this.classLoader instanceof Closeable) {
                ((Closeable)((Object)this.classLoader)).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static Resolution locate(ClassLoader classLoader, String typeName) throws IOException {
            InputStream inputStream = classLoader.getResourceAsStream(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                    return explicit;
                }
                finally {
                    inputStream.close();
                }
            }
            return new Resolution.Illegal(typeName);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoader.equals(((ForClassLoader)other).classLoader);
        }

        public int hashCode() {
            return this.classLoader.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.ForClassLoader{classLoader=" + this.classLoader + '}';
        }

        public static class WeaklyReferenced
        extends WeakReference<ClassLoader>
        implements ClassFileLocator {
            private final int hashCode;

            protected WeaklyReferenced(ClassLoader classLoader) {
                super(classLoader);
                this.hashCode = System.identityHashCode(classLoader);
            }

            public static ClassFileLocator of(ClassLoader classLoader) {
                return classLoader == null || classLoader == ClassLoader.getSystemClassLoader() ? ForClassLoader.of(classLoader) : new WeaklyReferenced(classLoader);
            }

            @Override
            public Resolution locate(String typeName) throws IOException {
                ClassLoader classLoader = (ClassLoader)this.get();
                return classLoader == null ? new Resolution.Illegal(typeName) : ForClassLoader.locate(classLoader, typeName);
            }

            @Override
            public void close() throws IOException {
                ClassLoader classLoader = (ClassLoader)this.get();
                if (classLoader instanceof Closeable) {
                    ((Closeable)((Object)classLoader)).close();
                }
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WeaklyReferenced that = (WeaklyReferenced)object;
                ClassLoader classLoader = (ClassLoader)that.get();
                return classLoader != null && this.get() == classLoader;
            }

            public String toString() {
                return "ClassFileLocator.ForClassLoader.WeaklyReferenced{classLoader=" + this.get() + ", hashCode=" + this.hashCode + '}';
            }
        }
    }

    public static class Simple
    implements ClassFileLocator {
        private final Map<String, byte[]> classFiles;

        public Simple(Map<String, byte[]> classFiles) {
            this.classFiles = classFiles;
        }

        public static ClassFileLocator of(String typeName, byte[] binaryRepresentation) {
            return new Simple(Collections.singletonMap(typeName, binaryRepresentation));
        }

        public static ClassFileLocator of(String typeName, byte[] binaryRepresentation, ClassFileLocator fallback) {
            return new Compound(new Simple(Collections.singletonMap(typeName, binaryRepresentation)), fallback);
        }

        @Override
        public Resolution locate(String typeName) {
            byte[] binaryRepresentation = this.classFiles.get(typeName);
            return binaryRepresentation == null ? new Resolution.Illegal(typeName) : new Resolution.Explicit(binaryRepresentation);
        }

        @Override
        public void close() {
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classFiles.equals(((Simple)other).classFiles);
        }

        public int hashCode() {
            return this.classFiles.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.Simple{classFiles=" + this.classFiles + '}';
        }
    }

    public static enum NoOp implements ClassFileLocator
    {
        INSTANCE;


        @Override
        public Resolution locate(String typeName) {
            return new Resolution.Illegal(typeName);
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return "ClassFileLocator.NoOp." + this.name();
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public byte[] resolve();

        public static class Explicit
        implements Resolution {
            private final byte[] binaryRepresentation;

            @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The array is not to be modified by contract")
            public Explicit(byte[] binaryRepresentation) {
                this.binaryRepresentation = binaryRepresentation;
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The array is not to be modified by contract")
            public byte[] resolve() {
                return this.binaryRepresentation;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.binaryRepresentation, ((Explicit)other).binaryRepresentation);
            }

            public int hashCode() {
                return Arrays.hashCode(this.binaryRepresentation);
            }

            public String toString() {
                return "ClassFileLocator.Resolution.Explicit{binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
            }
        }

        public static class Illegal
        implements Resolution {
            private final String typeName;

            public Illegal(String typeName) {
                this.typeName = typeName;
            }

            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public byte[] resolve() {
                throw new IllegalStateException("Could not locate class file for " + this.typeName);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Illegal illegal = (Illegal)object;
                return this.typeName.equals(illegal.typeName);
            }

            public int hashCode() {
                return this.typeName.hashCode();
            }

            public String toString() {
                return "ClassFileLocator.Resolution.Illegal{typeName='" + this.typeName + '\'' + '}';
            }
        }
    }
}

