/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.JavaInstance;

public class JavaInstanceConstant
implements StackManipulation {
    private final JavaInstance javaInstance;

    public JavaInstanceConstant(JavaInstance javaInstance) {
        this.javaInstance = javaInstance;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn(this.javaInstance.asConstantPoolValue());
        return StackSize.SINGLE.toIncreasingSize();
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.javaInstance.equals(((JavaInstanceConstant)other).javaInstance);
    }

    public int hashCode() {
        return this.javaInstance.hashCode();
    }

    public String toString() {
        return "JavaInstanceConstant{javaInstance=" + this.javaInstance + '}';
    }
}

