/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;

public class MethodDelegation
implements Implementation.Composable {
    private final ImplementationDelegate implementationDelegate;
    private final List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders;
    private final TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider;
    private final TargetMethodAnnotationDrivenBinder.TerminationHandler terminationHandler;
    private final MethodDelegationBinder.AmbiguityResolver ambiguityResolver;
    private final Assigner assigner;
    private final MethodContainer methodContainer;

    protected MethodDelegation(ImplementationDelegate implementationDelegate, List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders, TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider, TargetMethodAnnotationDrivenBinder.TerminationHandler terminationHandler, MethodDelegationBinder.AmbiguityResolver ambiguityResolver, Assigner assigner, MethodContainer methodContainer) {
        this.implementationDelegate = implementationDelegate;
        this.parameterBinders = parameterBinders;
        this.defaultsProvider = defaultsProvider;
        this.terminationHandler = terminationHandler;
        this.ambiguityResolver = ambiguityResolver;
        this.assigner = assigner;
        this.methodContainer = methodContainer;
    }

    public static MethodDelegation to(Class<?> type) {
        return MethodDelegation.to(new TypeDescription.ForLoadedType(type));
    }

    public static MethodDelegation to(TypeDescription typeDescription) {
        if (typeDescription.isArray()) {
            throw new IllegalArgumentException("Cannot delegate to array " + typeDescription);
        }
        if (typeDescription.isPrimitive()) {
            throw new IllegalArgumentException("Cannot delegate to primitive " + typeDescription);
        }
        return new MethodDelegation(ImplementationDelegate.ForStaticMethod.INSTANCE, TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, MethodContainer.ForExplicitMethods.ofStatic(typeDescription));
    }

    public static MethodDelegation to(Object delegate) {
        return MethodDelegation.to(delegate, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.to(delegate, delegate.getClass(), methodGraphCompiler);
    }

    public static MethodDelegation to(Object delegate, String fieldName) {
        return MethodDelegation.to(delegate, fieldName, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.to(delegate, delegate.getClass(), fieldName, methodGraphCompiler);
    }

    public static MethodDelegation to(Object delegate, Type type) {
        return MethodDelegation.to(delegate, type, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, Type type, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.to(delegate, type, String.format("%s$%d", "delegate", Math.abs(delegate.hashCode() % Integer.MAX_VALUE)), methodGraphCompiler);
    }

    public static MethodDelegation to(Object delegate, Type type, String fieldName) {
        return MethodDelegation.to(delegate, type, fieldName, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation to(Object delegate, Type type, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        TypeDescription.Generic typeDescription = TypeDefinition.Sort.describe(type);
        if (!typeDescription.asErasure().isInstance(delegate)) {
            throw new IllegalArgumentException(delegate + " is not an instance of " + type);
        }
        return new MethodDelegation(new ImplementationDelegate.ForStaticField(delegate, fieldName), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, new MethodContainer.ForVirtualMethods(methodGraphCompiler, typeDescription));
    }

    public static MethodDelegation toInstanceField(Class<?> type, String fieldName) {
        return MethodDelegation.toInstanceField(new TypeDescription.ForLoadedType(type), fieldName);
    }

    public static MethodDelegation toInstanceField(TypeDescription typeDescription, String fieldName) {
        return MethodDelegation.toInstanceField(typeDescription, fieldName, MethodGraph.Compiler.DEFAULT);
    }

    public static MethodDelegation toInstanceField(Class<?> type, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        return MethodDelegation.toInstanceField(new TypeDescription.ForLoadedType(type), fieldName, methodGraphCompiler);
    }

    public static MethodDelegation toInstanceField(TypeDefinition typeDefinition, String fieldName, MethodGraph.Compiler methodGraphCompiler) {
        return new MethodDelegation(new ImplementationDelegate.ForInstanceField(typeDefinition.asGenericType(), fieldName), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, new MethodContainer.ForVirtualMethods(methodGraphCompiler, typeDefinition.asGenericType()));
    }

    public static MethodDelegation toConstructor(Class<?> type) {
        return MethodDelegation.toConstructor(new TypeDescription.ForLoadedType(type));
    }

    public static MethodDelegation toConstructor(TypeDescription typeDescription) {
        return new MethodDelegation(new ImplementationDelegate.ForConstruction(typeDescription), TargetMethodAnnotationDrivenBinder.ParameterBinder.DEFAULTS, Argument.NextUnboundAsDefaultsProvider.INSTANCE, TargetMethodAnnotationDrivenBinder.TerminationHandler.Returning.INSTANCE, MethodDelegationBinder.AmbiguityResolver.DEFAULT, Assigner.DEFAULT, MethodContainer.ForExplicitMethods.ofConstructors(typeDescription));
    }

    public MethodDelegation appendParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> parameterBinder) {
        return new MethodDelegation(this.implementationDelegate, CompoundList.of(this.parameterBinders, parameterBinder), this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner, this.methodContainer);
    }

    public MethodDelegation defineParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> ... parameterBinder) {
        return new MethodDelegation(this.implementationDelegate, Arrays.asList(parameterBinder), this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner, this.methodContainer);
    }

    public MethodDelegation withDefaultsProvider(TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner, this.methodContainer);
    }

    public MethodDelegation appendAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ambiguityResolver) {
        return this.defineAmbiguityResolver(new MethodDelegationBinder.AmbiguityResolver.Chain(this.ambiguityResolver, ambiguityResolver));
    }

    public MethodDelegation defineAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ... ambiguityResolver) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, new MethodDelegationBinder.AmbiguityResolver.Chain(ambiguityResolver), this.assigner, this.methodContainer);
    }

    public MethodDelegation withAssigner(Assigner assigner) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, assigner, this.methodContainer);
    }

    public MethodDelegation filter(ElementMatcher<? super MethodDescription> methodMatcher) {
        return new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.ambiguityResolver, this.assigner, this.methodContainer.filter(methodMatcher));
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new MethodDelegation(this.implementationDelegate, this.parameterBinders, this.defaultsProvider, TargetMethodAnnotationDrivenBinder.TerminationHandler.Dropping.INSTANCE, this.ambiguityResolver, this.assigner, this.methodContainer), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.implementationDelegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this.implementationDelegate.getPreparingStackAssignment(implementationTarget.getInstrumentedType()), implementationTarget, this.methodContainer.resolve(implementationTarget.getInstrumentedType()), new MethodDelegationBinder.Processor(new TargetMethodAnnotationDrivenBinder(this.parameterBinders, this.defaultsProvider, this.terminationHandler, this.assigner, this.implementationDelegate.getMethodInvoker(implementationTarget.getInstrumentedType())), this.ambiguityResolver));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodDelegation that = (MethodDelegation)other;
        return this.ambiguityResolver.equals(that.ambiguityResolver) && this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.terminationHandler.equals(that.terminationHandler) && this.implementationDelegate.equals(that.implementationDelegate) && this.methodContainer.equals(that.methodContainer) && this.parameterBinders.equals(that.parameterBinders);
    }

    public int hashCode() {
        int result = this.implementationDelegate.hashCode();
        result = 31 * result + this.parameterBinders.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.terminationHandler.hashCode();
        result = 31 * result + this.ambiguityResolver.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.methodContainer.hashCode();
        return result;
    }

    public String toString() {
        return "MethodDelegation{implementationDelegate=" + this.implementationDelegate + ", parameterBinders=" + this.parameterBinders + ", defaultsProvider=" + this.defaultsProvider + ", terminationHandler=" + this.terminationHandler + ", ambiguityResolver=" + this.ambiguityResolver + ", assigner=" + this.assigner + ", methodContainer=" + this.methodContainer + '}';
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final StackManipulation preparingStackAssignment;
        private final Implementation.Target implementationTarget;
        private final MethodList targetCandidates;
        private final MethodDelegationBinder.Processor processor;

        protected Appender(StackManipulation preparingStackAssignment, Implementation.Target implementationTarget, MethodList targetCandidates, MethodDelegationBinder.Processor processor) {
            this.preparingStackAssignment = preparingStackAssignment;
            this.implementationTarget = implementationTarget;
            this.targetCandidates = targetCandidates;
            this.processor = processor;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.preparingStackAssignment, this.processor.process(this.implementationTarget, instrumentedMethod, this.targetCandidates)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender that = (Appender)other;
            return this.implementationTarget.equals(that.implementationTarget) && this.preparingStackAssignment.equals(that.preparingStackAssignment) && this.processor.equals(that.processor) && this.targetCandidates.equals(that.targetCandidates);
        }

        public int hashCode() {
            int result = this.preparingStackAssignment.hashCode();
            result = 31 * result + this.implementationTarget.hashCode();
            result = 31 * result + this.targetCandidates.hashCode();
            result = 31 * result + this.processor.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDelegation.Appender{preparingStackAssignment=" + this.preparingStackAssignment + ", implementationTarget=" + this.implementationTarget + ", targetCandidates=" + this.targetCandidates + ", processor=" + this.processor + '}';
        }
    }

    protected static interface MethodContainer {
        public MethodContainer filter(ElementMatcher<? super MethodDescription> var1);

        public MethodList<?> resolve(TypeDescription var1);

        public static class ForVirtualMethods
        implements MethodContainer {
            private final MethodGraph.Compiler methodGraphCompiler;
            private final TypeDescription.Generic targetType;
            private final ElementMatcher<? super MethodDescription> matcher;

            protected ForVirtualMethods(MethodGraph.Compiler methodGraphCompiler, TypeDescription.Generic targetType) {
                this(methodGraphCompiler, targetType, ElementMatchers.any());
            }

            private ForVirtualMethods(MethodGraph.Compiler methodGraphCompiler, TypeDescription.Generic targetType, ElementMatcher<? super MethodDescription> matcher) {
                this.methodGraphCompiler = methodGraphCompiler;
                this.targetType = targetType;
                this.matcher = matcher;
            }

            @Override
            public MethodContainer filter(ElementMatcher<? super MethodDescription> matcher) {
                return new ForVirtualMethods(this.methodGraphCompiler, this.targetType, new ElementMatcher.Junction.Conjunction<MethodDescription>(this.matcher, matcher));
            }

            @Override
            public MethodList<?> resolve(TypeDescription instrumentedType) {
                if (!this.targetType.asErasure().isVisibleTo(instrumentedType)) {
                    throw new IllegalStateException(instrumentedType + " cannot access " + this.targetType);
                }
                return (MethodList)this.methodGraphCompiler.compile(this.targetType, instrumentedType).listNodes().asMethodList().filter(this.matcher);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForVirtualMethods that = (ForVirtualMethods)other;
                return this.methodGraphCompiler.equals(that.methodGraphCompiler) && this.targetType.equals(that.targetType) && this.matcher.equals(that.matcher);
            }

            public int hashCode() {
                int result = this.methodGraphCompiler.hashCode();
                result = 31 * result + this.targetType.hashCode();
                result = 31 * result + this.matcher.hashCode();
                return result;
            }

            public String toString() {
                return "MethodDelegation.MethodContainer.ForVirtualMethods{methodGraphCompiler=" + this.methodGraphCompiler + ", targetType=" + this.targetType + ", matcher=" + this.matcher + '}';
            }
        }

        public static class ForExplicitMethods
        implements MethodContainer {
            private final MethodList<?> methodList;

            protected ForExplicitMethods(MethodList<?> methodList) {
                this.methodList = methodList;
            }

            protected static MethodContainer ofStatic(TypeDescription typeDescription) {
                return new ForExplicitMethods((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isStatic()));
            }

            protected static MethodContainer ofConstructors(TypeDescription typeDescription) {
                return new ForExplicitMethods((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isConstructor()));
            }

            @Override
            public MethodContainer filter(ElementMatcher<? super MethodDescription> matcher) {
                return new ForExplicitMethods((MethodList)this.methodList.filter(matcher));
            }

            @Override
            public MethodList<?> resolve(TypeDescription instrumentedType) {
                return (MethodList)this.methodList.filter(ElementMatchers.isVisibleTo(instrumentedType));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodList.equals(((ForExplicitMethods)other).methodList);
            }

            public int hashCode() {
                return this.methodList.hashCode();
            }

            public String toString() {
                return "MethodDelegation.MethodContainer.ForExplicitMethods{methodList=" + this.methodList + '}';
            }
        }
    }

    protected static interface ImplementationDelegate {
        public InstrumentedType prepare(InstrumentedType var1);

        public StackManipulation getPreparingStackAssignment(TypeDescription var1);

        public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription var1);

        public static class ForConstruction
        implements ImplementationDelegate {
            private final TypeDescription typeDescription;

            public ForConstruction(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(TypeCreation.forType(this.typeDescription), Duplication.SINGLE);
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForConstruction)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForConstruction{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static class ForInstanceField
        implements ImplementationDelegate {
            private final String fieldName;
            private final TypeDescription.Generic fieldType;

            public ForInstanceField(TypeDescription.Generic fieldType, String fieldName) {
                this.fieldType = fieldType;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 1, this.fieldType));
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter());
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(this.fieldType.asErasure());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForInstanceField)other).fieldName) && this.fieldType.equals(((ForInstanceField)other).fieldType);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.fieldType.hashCode();
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForInstanceField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
            }
        }

        public static class ForStaticField
        implements ImplementationDelegate {
            protected static final String PREFIX = "delegate";
            private final String fieldName;
            private final Object delegate;

            public ForStaticField(Object delegate, String fieldName) {
                this.delegate = delegate;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(this.delegate.getClass()))).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.delegate));
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter();
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(new TypeDescription.ForLoadedType(this.delegate.getClass()));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.delegate.equals(((ForStaticField)other).delegate) && this.fieldName.equals(((ForStaticField)other).fieldName);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.delegate.hashCode();
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForStaticField{fieldName='" + this.fieldName + '\'' + ", delegate=" + this.delegate + '}';
            }
        }

        public static enum ForStaticMethod implements ImplementationDelegate
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }

            public String toString() {
                return "MethodDelegation.ImplementationDelegate.ForStaticMethod." + this.name();
            }
        }
    }
}

