/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.member;

import java.util.ArrayList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum MethodVariableAccess {
    INTEGER(21, StackSize.SINGLE),
    LONG(22, StackSize.DOUBLE),
    FLOAT(23, StackSize.SINGLE),
    DOUBLE(24, StackSize.DOUBLE),
    REFERENCE(25, StackSize.SINGLE);

    private final int loadOpcode;
    private final StackManipulation.Size size;

    private MethodVariableAccess(int loadOpcode, StackSize stackSize) {
        this.loadOpcode = loadOpcode;
        this.size = stackSize.toIncreasingSize();
    }

    public static MethodVariableAccess forType(TypeDescription typeDescription) {
        if (typeDescription.isPrimitive()) {
            if (typeDescription.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDescription.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDescription.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDescription.represents(Void.TYPE)) {
                throw new IllegalArgumentException("Variable type cannot be void");
            }
            return INTEGER;
        }
        return REFERENCE;
    }

    public static MethodLoading allArgumentsOf(MethodDescription methodDescription) {
        return new MethodLoading(methodDescription, MethodLoading.TypeCastingHandler.NoOp.INSTANCE);
    }

    public StackManipulation loadOffset(int variableOffset) {
        return new OffsetLoading(variableOffset);
    }

    public String toString() {
        return "MethodVariableAccess." + this.name();
    }

    protected class OffsetLoading
    implements StackManipulation {
        private final int offset;

        protected OffsetLoading(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitVarInsn(MethodVariableAccess.this.loadOpcode, this.offset);
            return MethodVariableAccess.this.size;
        }

        private MethodVariableAccess getMethodVariableAccess() {
            return MethodVariableAccess.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && MethodVariableAccess.this == ((OffsetLoading)other).getMethodVariableAccess() && this.offset == ((OffsetLoading)other).offset;
        }

        public int hashCode() {
            return MethodVariableAccess.this.hashCode() + 31 * this.offset;
        }

        public String toString() {
            return "MethodVariableAccess.OffsetLoading{methodVariableAccess=" + (Object)((Object)MethodVariableAccess.this) + " ,offset=" + this.offset + '}';
        }
    }

    public static class MethodLoading
    implements StackManipulation {
        private final MethodDescription methodDescription;
        private final TypeCastingHandler typeCastingHandler;

        protected MethodLoading(MethodDescription methodDescription, TypeCastingHandler typeCastingHandler) {
            this.methodDescription = methodDescription;
            this.typeCastingHandler = typeCastingHandler;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(this.methodDescription.getParameters().size() * 2);
            for (ParameterDescription parameterDescription : this.methodDescription.getParameters()) {
                TypeDescription parameterType = parameterDescription.getType().asErasure();
                stackManipulations.add(MethodVariableAccess.forType(parameterType).loadOffset(parameterDescription.getOffset()));
                stackManipulations.add(this.typeCastingHandler.ofIndex(parameterType, parameterDescription.getIndex()));
            }
            return new StackManipulation.Compound(stackManipulations).apply(methodVisitor, implementationContext);
        }

        public StackManipulation prependThisReference() {
            return this.methodDescription.isStatic() ? this : new StackManipulation.Compound(REFERENCE.loadOffset(0), this);
        }

        public MethodLoading asBridgeOf(MethodDescription bridgeTarget) {
            return new MethodLoading(this.methodDescription, new TypeCastingHandler.ForBridgeTarget(bridgeTarget));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodLoading that = (MethodLoading)other;
            return this.methodDescription.equals(that.methodDescription) && this.typeCastingHandler.equals(that.typeCastingHandler);
        }

        public int hashCode() {
            int result = this.methodDescription.hashCode();
            result = 31 * result + this.typeCastingHandler.hashCode();
            return result;
        }

        public String toString() {
            return "MethodVariableAccess.MethodLoading{methodDescription=" + this.methodDescription + ", typeCastingHandler=" + this.typeCastingHandler + '}';
        }

        protected static interface TypeCastingHandler {
            public StackManipulation ofIndex(TypeDescription var1, int var2);

            public static class ForBridgeTarget
            implements TypeCastingHandler {
                private final MethodDescription bridgeTarget;

                public ForBridgeTarget(MethodDescription bridgeTarget) {
                    this.bridgeTarget = bridgeTarget;
                }

                @Override
                public StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    TypeDescription targetType = ((ParameterDescription)this.bridgeTarget.getParameters().get(index)).getType().asErasure();
                    return parameterType.equals(targetType) ? StackManipulation.Trivial.INSTANCE : TypeCasting.to(targetType);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForBridgeTarget that = (ForBridgeTarget)other;
                    return this.bridgeTarget.equals(that.bridgeTarget);
                }

                public int hashCode() {
                    return this.bridgeTarget.hashCode();
                }

                public String toString() {
                    return "MethodVariableAccess.MethodLoading.TypeCastingHandler.ForBridgeTarget{bridgeTarget=" + this.bridgeTarget + '}';
                }
            }

            public static enum NoOp implements TypeCastingHandler
            {
                INSTANCE;


                @Override
                public StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    return StackManipulation.Trivial.INSTANCE;
                }

                public String toString() {
                    return "MethodVariableAccess.MethodLoading.TypeCastingHandler.NoOp." + this.name();
                }
            }
        }
    }
}

