/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.auxiliary;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.utility.RandomString;

public interface AuxiliaryType {
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY", "MS_OOI_PKGPROTECT"}, justification="Favor simplicity with current API in overall immutable library layout - value should be accessible to extensions")
    public static final ModifierContributor.ForType[] DEFAULT_TYPE_MODIFIER = new ModifierContributor.ForType[]{SyntheticState.SYNTHETIC};

    public DynamicType make(String var1, ClassFileVersion var2, MethodAccessorFactory var3);

    public static interface NamingStrategy {
        public String name(TypeDescription var1);

        public static class SuffixingRandom
        implements NamingStrategy {
            private final String suffix;
            private final RandomString randomString;

            public SuffixingRandom(String suffix) {
                this.suffix = suffix;
                this.randomString = new RandomString();
            }

            @Override
            public String name(TypeDescription instrumentedType) {
                return String.format("%s$%s$%s", instrumentedType.getName(), this.suffix, this.randomString.nextString());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((SuffixingRandom)other).suffix);
            }

            public int hashCode() {
                return this.suffix.hashCode();
            }

            public String toString() {
                return "Instrumentation.Context.Default.AuxiliaryTypeNamingStrategySuffixingRandom{suffix='" + this.suffix + '\'' + '}';
            }
        }
    }

    public static interface MethodAccessorFactory {
        public MethodDescription.InDefinedShape registerAccessorFor(Implementation.SpecialMethodInvocation var1);

        public MethodDescription.InDefinedShape registerGetterFor(FieldDescription var1);

        public MethodDescription.InDefinedShape registerSetterFor(FieldDescription var1);

        public static enum Illegal implements MethodAccessorFactory
        {
            INSTANCE;


            @Override
            public MethodDescription.InDefinedShape registerAccessorFor(Implementation.SpecialMethodInvocation specialMethodInvocation) {
                throw new IllegalStateException("It is illegal to register an accessor for this type");
            }

            @Override
            public MethodDescription.InDefinedShape registerGetterFor(FieldDescription fieldDescription) {
                throw new IllegalStateException("It is illegal to register a field getter for this type");
            }

            @Override
            public MethodDescription.InDefinedShape registerSetterFor(FieldDescription fieldDescription) {
                throw new IllegalStateException("It is illegal to register a field setter for this type");
            }

            public String toString() {
                return "AuxiliaryType.MethodAccessorFactory.Illegal." + this.name();
            }
        }
    }
}

