/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.inline.MethodRebaseResolver;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;

public class RebaseImplementationTarget
extends Implementation.Target.AbstractBase {
    private final Map<MethodDescription.Token, MethodRebaseResolver.Resolution> rebaseableMethods;

    protected RebaseImplementationTarget(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, Map<MethodDescription.Token, MethodRebaseResolver.Resolution> rebasements) {
        super(instrumentedType, methodGraph);
        this.rebaseableMethods = rebasements;
    }

    protected static Implementation.Target of(TypeDescription instrumentedType, MethodGraph.Linked methodGraph, MethodList<MethodDescription.InDefinedShape> rebaseableMethods, MethodRebaseResolver methodRebaseResolver) {
        HashMap<MethodDescription.Token, MethodRebaseResolver.Resolution> rebasements = new HashMap<MethodDescription.Token, MethodRebaseResolver.Resolution>(rebaseableMethods.size());
        for (MethodDescription.InDefinedShape methodDescription : rebaseableMethods) {
            rebasements.put((MethodDescription.Token)methodDescription.asToken(), methodRebaseResolver.resolve(methodDescription));
        }
        return new RebaseImplementationTarget(instrumentedType, methodGraph, rebasements);
    }

    @Override
    public Implementation.SpecialMethodInvocation invokeSuper(MethodDescription.Token methodToken) {
        MethodRebaseResolver.Resolution resolution = this.rebaseableMethods.get(methodToken);
        return resolution == null ? this.invokeSuper(this.methodGraph.getSuperGraph().locate(methodToken)) : this.invokeSuper(resolution);
    }

    private Implementation.SpecialMethodInvocation invokeSuper(MethodGraph.Node node) {
        return node.getSort().isResolved() ? Implementation.SpecialMethodInvocation.Simple.of(node.getRepresentative(), this.instrumentedType.getSuperType().asErasure()) : Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
    }

    private Implementation.SpecialMethodInvocation invokeSuper(MethodRebaseResolver.Resolution resolution) {
        return resolution.isRebased() ? RebasedMethodInvocation.of(resolution.getResolvedMethod(), this.instrumentedType, resolution.getAdditionalArguments()) : Implementation.SpecialMethodInvocation.Simple.of(resolution.getResolvedMethod(), this.instrumentedType);
    }

    @Override
    public TypeDescription getOriginType() {
        return this.instrumentedType;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.rebaseableMethods.equals(((RebaseImplementationTarget)other).rebaseableMethods);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.rebaseableMethods.hashCode();
        return result;
    }

    public String toString() {
        return "RebaseImplementationTarget{, instrumentedType=" + this.instrumentedType + ", methodGraph=" + this.methodGraph + ", rebaseableMethods=" + this.rebaseableMethods + '}';
    }

    public static class Factory
    implements Implementation.Target.Factory {
        private final MethodList<MethodDescription.InDefinedShape> rebaseableMethods;
        private final MethodRebaseResolver methodRebaseResolver;

        public Factory(MethodList<MethodDescription.InDefinedShape> rebaseableMethods, MethodRebaseResolver methodRebaseResolver) {
            this.rebaseableMethods = rebaseableMethods;
            this.methodRebaseResolver = methodRebaseResolver;
        }

        @Override
        public Implementation.Target make(TypeDescription instrumentedType, MethodGraph.Linked methodGraph) {
            return RebaseImplementationTarget.of(instrumentedType, methodGraph, this.rebaseableMethods, this.methodRebaseResolver);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodRebaseResolver.equals(((Factory)other).methodRebaseResolver) && this.rebaseableMethods.equals(((Factory)other).rebaseableMethods);
        }

        public int hashCode() {
            return this.methodRebaseResolver.hashCode() + 31 * this.rebaseableMethods.hashCode();
        }

        public String toString() {
            return "RebaseImplementationTarget.Factory{methodRebaseResolver=" + this.methodRebaseResolver + ", rebaseableMethods=" + this.rebaseableMethods + '}';
        }
    }

    protected static class RebasedMethodInvocation
    extends Implementation.SpecialMethodInvocation.AbstractBase {
        private final MethodDescription methodDescription;
        private final TypeDescription instrumentedType;
        private final StackManipulation stackManipulation;

        protected RebasedMethodInvocation(MethodDescription methodDescription, TypeDescription instrumentedType, StackManipulation stackManipulation) {
            this.methodDescription = methodDescription;
            this.instrumentedType = instrumentedType;
            this.stackManipulation = stackManipulation;
        }

        protected static Implementation.SpecialMethodInvocation of(MethodDescription resolvedMethod, TypeDescription instrumentedType, StackManipulation additionalArguments) {
            MethodInvocation.WithImplicitInvocationTargetType stackManipulation = resolvedMethod.isStatic() ? MethodInvocation.invoke(resolvedMethod) : MethodInvocation.invoke(resolvedMethod).special(instrumentedType);
            return stackManipulation.isValid() ? new RebasedMethodInvocation(resolvedMethod, instrumentedType, new StackManipulation.Compound(additionalArguments, stackManipulation)) : Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
        }

        @Override
        public MethodDescription getMethodDescription() {
            return this.methodDescription;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.instrumentedType;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return this.stackManipulation.apply(methodVisitor, implementationContext);
        }

        public String toString() {
            return "RebaseImplementationTarget.RebasedMethodInvocation{instrumentedType=" + this.instrumentedType + ", methodDescription=" + this.methodDescription + ", stackManipulation=" + this.stackManipulation + '}';
        }
    }
}

