/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import com.android.build.gradle.BaseExtension;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AndroidDescriptor;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.android.ByteBuddyAndroidTaskExtension;
import net.bytebuddy.build.gradle.android.Discovery;
import net.bytebuddy.build.gradle.android.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.utility.QueueFactory;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ByteBuddyLocalClassesEnhancerTask
extends DefaultTask {
    @Nested
    public abstract ListProperty<Transformation> getTransformations();

    @InputFiles
    public abstract ConfigurableFileCollection getAndroidBootClasspath();

    @InputFiles
    public abstract ConfigurableFileCollection getByteBuddyClasspath();

    @Input
    public abstract Property<JavaVersion> getJavaTargetCompatibilityVersion();

    @Input
    public abstract Property<Discovery> getDiscovery();

    @Input
    public abstract Property<EntryPoint> getEntryPoint();

    @InputFiles
    public abstract ListProperty<RegularFile> getInputJars();

    @InputFiles
    public abstract ListProperty<Directory> getLocalClassesDirs();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Internal
    public abstract Property<Boolean> getWarnOnEmptyTypeSet();

    @Internal
    public abstract Property<Boolean> getFailFast();

    @Internal
    public abstract Property<Boolean> getFailOnLiveInitializer();

    @Internal
    public abstract Property<Integer> getThreads();

    @Input
    public abstract Property<String> getSuffix();

    @Input
    public abstract Property<Boolean> getExtendedParsing();

    @MaybeNull
    @InputFiles
    @Optional
    public abstract ConfigurableFileCollection getDiscoverySet();

    private static URL[] toUrls(Collection<File> files) {
        URL[] url = new URL[files.size()];
        int index = 0;
        for (File file : files) {
            try {
                url[index++] = file.toURI().toURL();
            }
            catch (MalformedURLException exception) {
                throw new IllegalStateException("Failed to convert file " + file.getAbsolutePath(), exception);
            }
        }
        return url;
    }

    @TaskAction
    public void execute() throws IOException {
        ArrayList<Object> transformations = new ArrayList<Object>(((List)this.getTransformations().get()).size());
        for (Transformation transformation : (List)this.getTransformations().get()) {
            transformations.add(transformation.resolve());
        }
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        HashSet<File> localClasspath = new HashSet<File>();
        for (Directory directory : (List)this.getLocalClassesDirs().get()) {
            File file = directory.getAsFile();
            localClasspath.add(file);
            sources.add(new Plugin.Engine.Source.ForFolder(file));
        }
        for (RegularFile jarFile : (List)this.getInputJars().get()) {
            sources.add(new Plugin.Engine.Source.ForJarFile(jarFile.getAsFile()));
        }
        ClassFileVersion classFileVersion = ClassFileVersion.ofJavaVersionString((String)((JavaVersion)this.getJavaTargetCompatibilityVersion().get()).toString());
        AndroidDescriptor androidDescriptor = DefaultAndroidDescriptor.ofClassPath(localClasspath);
        URLClassLoader classLoader = new URLClassLoader(ByteBuddyLocalClassesEnhancerTask.toUrls(this.getByteBuddyClasspath().getFiles()), (ClassLoader)new URLClassLoader(ByteBuddyLocalClassesEnhancerTask.toUrls(this.getAndroidBootClasspath().getFiles()), ByteBuddy.class.getClassLoader()));
        try {
            Class<?> discovery = Class.forName("net.bytebuddy.build.gradle.Discovery");
            Class.forName("net.bytebuddy.build.gradle.AbstractByteBuddyTask").getMethod("apply", Logger.class, ClassLoader.class, List.class, discovery, ClassFileLocator.class, Iterable.class, Iterable.class, EntryPoint.class, ClassFileVersion.class, ClassFileVersion.class, Plugin.Factory.UsingReflection.ArgumentResolver.class, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Plugin.Engine.Source.class, Plugin.Engine.Target.class).invoke(null, new Object[]{this.getLogger(), classLoader, transformations, discovery.getMethod("valueOf", String.class).invoke(null, ((Discovery)((Object)this.getDiscovery().get())).name()), ClassFileLocator.ForClassLoader.of((ClassLoader)ByteBuddy.class.getClassLoader()), this.getAndroidBootClasspath().plus((FileCollection)this.getByteBuddyClasspath()).getFiles(), this.getDiscoverySet().getFiles(), this.getEntryPoint().get(), classFileVersion, classFileVersion, Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(AndroidDescriptor.class, (Object)androidDescriptor), this.getSuffix().get(), this.getThreads().get(), this.getExtendedParsing().get(), this.getFailFast().get(), this.getFailOnLiveInitializer().get(), this.getWarnOnEmptyTypeSet().get(), new Plugin.Engine.Source.Compound(sources), new TargetForAndroidAppJarFile(((RegularFile)this.getOutputFile().get()).getAsFile())});
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new GradleException("Unexpected transformation error", cause);
        }
        catch (Throwable throwable) {
            throw new GradleException("Unexpected transformation error", throwable);
        }
        finally {
            if (classLoader instanceof Closeable) {
                ((Closeable)classLoader).close();
            }
        }
    }

    protected static class TargetForAndroidAppJarFile
    extends Plugin.Engine.Target.ForJarFile {
        private final File file;

        protected TargetForAndroidAppJarFile(File file) {
            super(file);
            this.file = file;
        }

        public Plugin.Engine.Target.Sink write(@MaybeNull Manifest manifest) throws IOException {
            FileOutputStream outputStream = new FileOutputStream(this.file);
            try {
                return manifest == null ? new ForAndroidAppOutputStream(new JarOutputStream(outputStream)) : new ForAndroidAppOutputStream(new JarOutputStream((OutputStream)outputStream, manifest));
            }
            catch (IOException exception) {
                ((OutputStream)outputStream).close();
                throw exception;
            }
            catch (RuntimeException exception) {
                ((OutputStream)outputStream).close();
                throw exception;
            }
            catch (Error error) {
                ((OutputStream)outputStream).close();
                throw error;
            }
        }

        protected static class ForAndroidAppOutputStream
        extends Plugin.Engine.Target.Sink.ForJarOutputStream {
            private final JarOutputStream outputStream;

            protected ForAndroidAppOutputStream(JarOutputStream outputStream) {
                super(outputStream);
                this.outputStream = outputStream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void retain(Plugin.Engine.Source.Element element) throws IOException {
                block9: {
                    JarEntry entry = (JarEntry)element.resolveAs(JarEntry.class);
                    if (entry != null && entry.isDirectory()) {
                        return;
                    }
                    String name = element.getName();
                    try {
                        this.outputStream.putNextEntry(new JarEntry(name));
                        if (!name.endsWith("/")) {
                            try (InputStream inputStream = element.getInputStream();){
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = inputStream.read(buffer)) != -1) {
                                    this.outputStream.write(buffer, 0, length);
                                }
                            }
                        }
                        this.outputStream.closeEntry();
                    }
                    catch (ZipException exception) {
                        if (name.startsWith("META-INF") || name.endsWith("-info.class") || !name.endsWith(".class")) break block9;
                        throw exception;
                    }
                }
            }
        }
    }

    protected static class DefaultAndroidDescriptor
    implements AndroidDescriptor {
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Set<String> names;

        protected DefaultAndroidDescriptor(Set<String> names) {
            this.names = names;
        }

        protected static AndroidDescriptor ofClassPath(Set<File> roots) {
            HashSet<String> names = new HashSet<String>();
            for (File root : roots) {
                Queue queue = QueueFactory.make(Collections.singleton(root));
                while (!queue.isEmpty()) {
                    File file = (File)queue.remove();
                    if (file.isDirectory()) {
                        File[] value = file.listFiles();
                        if (value == null) continue;
                        queue.addAll(Arrays.asList(value));
                        continue;
                    }
                    if (!file.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
                    String path = root.getAbsoluteFile().toURI().relativize(file.getAbsoluteFile().toURI()).getPath();
                    names.add(path.substring(0, path.length() - CLASS_FILE_EXTENSION.length()).replace('/', '.'));
                }
            }
            return new DefaultAndroidDescriptor(names);
        }

        public AndroidDescriptor.TypeScope getTypeScope(TypeDescription typeDescription) {
            return this.names.contains(typeDescription.getName()) ? AndroidDescriptor.TypeScope.LOCAL : AndroidDescriptor.TypeScope.EXTERNAL;
        }
    }

    public static class ConfigurationAction
    implements Action<ByteBuddyLocalClassesEnhancerTask> {
        private final FileCollection byteBuddyConfiguration;
        private final BaseExtension androidExtension;
        private final ByteBuddyAndroidTaskExtension byteBuddyExtension;

        public ConfigurationAction(FileCollection byteBuddyConfiguration, BaseExtension androidExtension, ByteBuddyAndroidTaskExtension byteBuddyExtension) {
            this.byteBuddyConfiguration = byteBuddyConfiguration;
            this.androidExtension = androidExtension;
            this.byteBuddyExtension = byteBuddyExtension;
        }

        public void execute(ByteBuddyLocalClassesEnhancerTask task) {
            task.getByteBuddyClasspath().from(new Object[]{this.byteBuddyConfiguration});
            task.getAndroidBootClasspath().from(new Object[]{this.androidExtension.getBootClasspath()});
            task.getJavaTargetCompatibilityVersion().set((Object)this.androidExtension.getCompileOptions().getTargetCompatibility());
            this.byteBuddyExtension.configure(task);
        }
    }
}

