/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema.nodes.impl;

import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import net.bpelunit.toolsupport.util.schema.nodes.SchemaNode;
import net.bpelunit.toolsupport.util.schema.nodes.impl.AttributeImpl;
import net.bpelunit.toolsupport.util.schema.nodes.impl.ComplexTypeImpl;
import net.bpelunit.toolsupport.util.schema.nodes.impl.ElementImpl;
import net.bpelunit.toolsupport.util.schema.nodes.impl.SchemaNodeTestAbstract;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComplexTypeImplTest
extends SchemaNodeTestAbstract {
    private ComplexType complex;

    @Before
    public void setUp() throws Exception {
        this.complex = new ComplexTypeImpl("http://www.test.org", "PersonType");
    }

    @Test
    public void testAddElement() {
        Assert.assertTrue((boolean)this.complex.getElements().isEmpty());
        ElementImpl element = new ElementImpl("http://www.test.org", "Name");
        this.complex.addElement(element);
        Assert.assertEquals((long)1L, (long)this.complex.getElements().size());
        Assert.assertTrue((boolean)this.complex.getElements().contains(element));
    }

    @Test
    public void testAddAttribute() {
        Assert.assertTrue((boolean)this.complex.getAttributes().isEmpty());
        AttributeImpl attribute = new AttributeImpl("http://www.test.org", "id");
        this.complex.addAttribute(attribute);
        Assert.assertEquals((long)1L, (long)this.complex.getAttributes().size());
        Assert.assertTrue((boolean)this.complex.getAttributes().contains(attribute));
    }

    @Test
    public void testIsSimpleType() throws Exception {
        Assert.assertFalse((boolean)this.complex.isSimpleType());
    }

    @Test
    public void testIsComplexType() throws Exception {
        Assert.assertTrue((boolean)this.complex.isComplexType());
    }

    @Test
    public void testGetAsSimpleType() throws Exception {
        Assert.assertNull((Object)this.complex.getAsSimpleType());
    }

    @Test
    public void testGetAsComplexType() throws Exception {
        Assert.assertSame((Object)this.complex, (Object)this.complex.getAsComplexType());
    }

    @Override
    protected SchemaNode constructSchemaNode(QName name) {
        return new ComplexTypeImpl(name);
    }

    @Override
    protected SchemaNode constructSchemaNode(String targetNs, String locaPart) {
        return new ComplexTypeImpl(targetNs, locaPart);
    }
}

