/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.ExtensionControl;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.DeployerOptionModifyListener;
import net.bpelunit.framework.client.eclipse.dialog.field.SelectionField;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.util.ExtensionRegistry;
import net.bpelunit.framework.xml.suite.XMLPUTDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLProperty;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.StructuredActivityWizardPage;
import net.bpelunit.toolsupport.editors.wizards.pages.XMLPropertyLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class DeploymentOptionWizardPage
extends StructuredActivityWizardPage {
    private ListDialogField fSelectionField;
    private XMLPUTDeploymentInformation fPutInfo;
    private String[] fPossibleParameterNames = null;
    private Class<? extends IBPELDeployer> fDeployerClass;

    public DeploymentOptionWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Configure Deployment");
        this.setDescription("Add or remove deployment option for the selected PUT deployer");
    }

    @Override
    public void handleAddPressed() {
        String[] edit = this.editProperty(null);
        if (edit != null) {
            XMLProperty xmlCondition = this.fPutInfo.addNewProperty();
            xmlCondition.setName(edit[0]);
            xmlCondition.setStringValue(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fSelectionField, false);
        }
    }

    @Override
    public void handleEditPressed() {
        XMLProperty current = this.getSelectedProperty();
        if (current == null) {
            return;
        }
        String[] edit = this.editProperty(current);
        if (edit != null) {
            current.setName(edit[0]);
            current.setStringValue(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fSelectionField, false);
        }
    }

    @Override
    public void handleRemovePressed() {
        int index;
        XMLProperty prop = this.getSelectedProperty();
        if (prop != null && (index = this.fPutInfo.getPropertyList().indexOf(prop)) != -1) {
            this.fPutInfo.removeProperty(index);
            this.recreateInput();
            this.enableButtonsForSelection(this.fSelectionField, false);
        }
    }

    private XMLProperty getSelectedProperty() {
        List<Object> selectedElements = this.fSelectionField.getSelectedElements();
        if (selectedElements.size() > 0) {
            return (XMLProperty)selectedElements.get(0);
        }
        return null;
    }

    public void recreateInput() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object o : this.fPutInfo.getPropertyList()) {
            l.add(o);
        }
        this.fSelectionField.setElements(l);
    }

    private String[] editProperty(XMLProperty currentProperty) {
        String initialKey = currentProperty != null ? currentProperty.getName() : null;
        String initialValue = currentProperty != null ? currentProperty.getStringValue() : null;
        String title = currentProperty != null ? "Edit an option " : "Add an option";
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        SelectionField keyField = new SelectionField(dialog, "Key", initialKey, "Keys...", this.fPossibleParameterNames);
        keyField.setValidator((DialogFieldValidator)new NotEmptyValidator("Key"));
        dialog.addField((Field)keyField);
        TextField valueField = new TextField(dialog, "Value", initialValue, TextField.Style.SINGLE);
        valueField.setValidator((DialogFieldValidator)new NotEmptyValidator("Value"));
        dialog.addField((Field)valueField);
        keyField.addModifyListener((ModifyListener)new DeployerOptionModifyListener(keyField, valueField, this.fDeployerClass));
        if (dialog.open() != 0) {
            return null;
        }
        String[] s = new String[]{keyField.getSelection(), valueField.getSelection()};
        return s;
    }

    public void init(XMLPUTDeploymentInformation putInfo) {
        this.fPutInfo = putInfo;
        StructuredActivityWizardPage.ListFieldListener deploymentConfigListener = this.createListFieldListener();
        this.fSelectionField = new ListDialogField(deploymentConfigListener, this.fButtons, (IBaseLabelProvider)new XMLPropertyLabelProvider());
        this.fSelectionField.setDialogFieldListener(deploymentConfigListener);
        this.fSelectionField.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Key", "Value"}, true));
        this.fSelectionField.setLabelText(null);
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object o : this.fPutInfo.getPropertyList()) {
            l.add(o);
        }
        this.fSelectionField.setElements(l);
        this.enableButtonsForSelection(this.fSelectionField, false);
        try {
            String deployerName = this.fPutInfo.getType();
            IBPELDeployer deployer = ExtensionControl.findDeployerExtension((String)deployerName).createNew();
            this.fDeployerClass = deployer.getClass();
            this.fPossibleParameterNames = ExtensionRegistry.getPossibleConfigurationOptions(deployer.getClass(), (boolean)true).toArray(new String[0]);
        }
        catch (Throwable throwable) {
            this.fPossibleParameterNames = new String[0];
        }
    }

    @Override
    protected void createFieldControls(Composite composite, int nColumns) {
        this.fSelectionField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.fSelectionField.getListControl(null).getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
    }

    @Override
    public WizardPageCode getCode() {
        return WizardPageCode.DEPLOYMENTOPTION;
    }
}

