/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.components;

import net.bpelunit.toolsupport.editors.wizards.components.DataComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.IDialogFieldListener;
import net.bpelunit.toolsupport.editors.wizards.fields.IListAdapter;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.FontMetrics;

public abstract class StructuredDataComponent
extends DataComponent {
    private final int BUTTON_ADD = 0;
    private final int BUTTON_EDIT = 1;
    private final int BUTTON_REMOVE = 2;
    protected static final String[] fButtons = new String[]{"&Add", "&Edit", "&Remove"};

    public StructuredDataComponent(IWizardPage page, FontMetrics metrics) {
        super(page, metrics);
    }

    protected void enableButtonsForSelection(ListDialogField field, boolean enable) {
        field.enableButton(1, enable);
        field.enableButton(2, enable);
    }

    protected abstract void handleRemovePressed();

    protected abstract void handleEditPressed();

    protected abstract void handleAddPressed();

    protected ListFieldListener createListFieldListener() {
        return new ListFieldListener();
    }

    protected class ListFieldListener
    implements IListAdapter,
    IDialogFieldListener {
        protected ListFieldListener() {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    StructuredDataComponent.this.handleAddPressed();
                    break;
                }
                case 1: {
                    StructuredDataComponent.this.handleEditPressed();
                    break;
                }
                case 2: {
                    StructuredDataComponent.this.handleRemovePressed();
                }
            }
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            StructuredDataComponent.this.handleEditPressed();
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            StructuredDataComponent.this.enableButtonsForSelection(field, true);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            StructuredDataComponent.this.fireValueChanged(field);
        }
    }
}

