/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.components;

import java.util.HashMap;
import net.bpelunit.framework.xml.suite.XMLAnyElement;
import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.formwidgets.HyperlinkField;
import net.bpelunit.toolsupport.editors.wizards.NamespaceWizard;
import net.bpelunit.toolsupport.editors.wizards.TransportOptionWizard;
import net.bpelunit.toolsupport.editors.wizards.components.DataComponent;
import net.bpelunit.toolsupport.editors.wizards.components.MessageChangeListener;
import net.bpelunit.toolsupport.editors.wizards.components.StringValueListener;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.IDialogFieldListener;
import net.bpelunit.toolsupport.editors.wizards.fields.LayoutUtil;
import net.bpelunit.toolsupport.editors.wizards.fields.MessageEditor;
import net.bpelunit.toolsupport.editors.wizards.fields.SelectionButtonDialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.StringDialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.TextDialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.OperationWizardPage;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class SendComponent
extends DataComponent
implements MessageChangeListener,
StringValueListener {
    protected TextDialogField fSendField;
    protected XMLSendActivity fSendData;
    protected StringDialogField fDelayStringField;
    protected SelectionButtonDialogField fDelaySelectionField;
    protected SelectionButtonDialogField enterLiteralXMLCheckBox;
    protected boolean fDelaySelected;
    protected MessageEditor messageEditor;
    protected TabItem literalXMLTab;
    private TabItem messageEditorTab;
    private TabFolder tabFolder;

    public SendComponent(IWizardPage wizard, FontMetrics metrics) {
        super(wizard, metrics);
    }

    public void init(XMLSendActivity sendData) {
        this.fSendData = sendData;
        this.fSendField = new TextDialogField();
        this.fSendField.setLabelText(null);
        this.fSendField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                SendComponent.this.fireValueChanged(field);
            }
        });
        this.fDelayStringField = new StringDialogField(true);
        this.fDelayStringField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                if (SendComponent.this.fDelaySelected) {
                    SendComponent.this.fireValueChanged(field);
                }
            }
        });
        this.fDelaySelectionField = new SelectionButtonDialogField(32);
        this.fDelaySelectionField.attachDialogField(this.fDelayStringField);
        this.fDelaySelectionField.setLabelText("Vary send delay");
        this.fDelaySelectionField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                SendComponent.this.fDelaySelected = SendComponent.this.fDelaySelectionField.isEnabled();
                SendComponent.this.fDelayStringField.setText("");
                SendComponent.this.fireValueChanged(field);
            }
        });
        this.enterLiteralXMLCheckBox = new SelectionButtonDialogField(32);
        this.enterLiteralXMLCheckBox.setLabelText("Enter XML literal");
        this.enterLiteralXMLCheckBox.setSelection(false);
        this.enterLiteralXMLCheckBox.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                SendComponent.this.setInputType();
            }
        });
        this.initValues();
    }

    protected void setInputType() {
        boolean selected = this.enterLiteralXMLCheckBox.isSelected();
        Image image = ToolSupportActivator.getImage("img_lock");
        if (selected) {
            this.messageEditorTab.setImage(image);
            this.literalXMLTab.setImage(null);
        } else {
            boolean reset;
            if (!this.messageEditor.isXMLValid() && !(reset = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Reset XML?", (String)"Continuing will reset the XML to the default message of the selected Operation. Continue anyway?"))) {
                this.enterLiteralXMLCheckBox.setSelection(true);
                return;
            }
            this.messageEditorTab.setImage(null);
            this.literalXMLTab.setImage(image);
        }
        this.fSendField.getTextControl(null).setEditable(selected);
        this.messageEditor.setEditable(!selected);
    }

    private void initValues() {
        XMLAnyElement data = this.fSendData.getData();
        if (data == null) {
            data = this.fSendData.addNewData();
        }
        if (!data.newCursor().toFirstChild()) {
            this.fSendField.setText("");
        } else {
            XmlOptions opts = new XmlOptions();
            opts.setSavePrettyPrint();
            opts.setSavePrettyPrintIndent(4);
            HashMap ns = new HashMap();
            this.getTestSuite().newCursor().getAllNamespaces(ns);
            opts.setSaveImplicitNamespaces(ns);
            this.fSendField.setText(this.fSendData.getData().xmlText(opts));
        }
        String delaySequence = this.fSendData.getDelaySequence();
        if (delaySequence == null || "".equals(delaySequence)) {
            delaySequence = "";
            this.fDelaySelected = false;
        } else {
            this.fDelaySelected = true;
        }
        this.fDelaySelectionField.setSelection(this.fDelaySelected);
        this.fDelayStringField.setText(delaySequence);
    }

    @Override
    public Composite createControls(Composite composite, int nColumns) {
        Group group = this.createGroup(composite, "Data to be sent", nColumns, new GridData(4, 4, true, true));
        this.tabFolder = new TabFolder((Composite)group, 128);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == SendComponent.this.literalXMLTab) {
                    SendComponent.this.fSendField.getTextControl(null).setFocus();
                }
            }
        });
        GridData gd = new GridData();
        gd.minimumHeight = 200;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = nColumns;
        this.tabFolder.setLayoutData((Object)gd);
        this.messageEditor = new MessageEditor((Composite)this.tabFolder, 0, this.getTestSuite());
        if (this.getWizardPage() instanceof OperationWizardPage) {
            OperationWizardPage comp = (OperationWizardPage)this.getWizardPage();
            comp.getOperationDataComponent().addMessageListener(this);
        }
        this.messageEditor.setXML(this.fSendField.getText());
        this.messageEditor.addStringValueListener(this);
        this.messageEditorTab = new TabItem(this.tabFolder, 0);
        this.messageEditorTab.setControl((Control)this.messageEditor);
        this.messageEditorTab.setText("Message Editor");
        this.fSendField.doFillIntoGrid((Composite)this.tabFolder, nColumns);
        this.literalXMLTab = new TabItem(this.tabFolder, 0);
        this.literalXMLTab.setImage(ToolSupportActivator.getImage("img_lock"));
        Text text = this.fSendField.getTextControl(null);
        text.setEditable(false);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (SendComponent.this.enterLiteralXMLCheckBox.isSelected()) {
                    String xml = SendComponent.this.getXmlText();
                    SendComponent.this.messageEditor.setXML(xml);
                }
            }
        });
        text.setFocus();
        this.literalXMLTab.setControl((Control)text);
        this.literalXMLTab.setText("XML to be sent");
        LayoutUtil.setHeightHint((Control)text, Dialog.convertHeightInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)6));
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        Composite inner = new Composite((Composite)group, 0);
        GridData gridData = new GridData(4, 1, true, false);
        inner.setLayoutData((Object)gridData);
        inner.setLayout((Layout)new GridLayout(10, false));
        this.enterLiteralXMLCheckBox.doFillIntoGrid(inner, 1);
        if (!this.messageEditor.isXMLValid() && !this.fSendField.getText().isEmpty()) {
            this.enterLiteralXMLCheckBox.setSelection(true);
            this.setInputType();
            this.tabFolder.setSelection(1);
        }
        DialogField.createEmptySpace(inner, 7);
        this.fDelaySelectionField.doFillIntoGrid(inner, 1);
        Button selectionButton = this.fDelaySelectionField.getSelectionButton(null);
        LayoutUtil.setVerticalAlign((Control)selectionButton, 2);
        this.fDelayStringField.doFillIntoGrid(inner, 1);
        Text textControl = this.fDelayStringField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)textControl);
        HyperlinkField namespacePrefixField = new HyperlinkField("Configure Namespace Prefixes...");
        namespacePrefixField.setHyperLinkFieldListener(new HyperlinkField.IHyperLinkFieldListener(){

            @Override
            public void hyperLinkActivated() {
                WizardDialog d = new WizardDialog(SendComponent.this.getShell(), (IWizard)new NamespaceWizard(SendComponent.this.getTestSuite()));
                if (d.open() == 0) {
                    SendComponent.this.fireValueChanged(SendComponent.this.fSendField);
                    SendComponent.this.messageEditor.updateItems();
                }
            }
        });
        namespacePrefixField.createControl((Composite)group, nColumns, 1);
        HyperlinkField transportOptionField = new HyperlinkField("Add HTTP Header...");
        transportOptionField.setHyperLinkFieldListener(new HyperlinkField.IHyperLinkFieldListener(){

            @Override
            public void hyperLinkActivated() {
                WizardDialog d = new WizardDialog(SendComponent.this.getShell(), (IWizard)new TransportOptionWizard(SendComponent.this.fSendData));
                if (d.open() == 0) {
                    SendComponent.this.fireValueChanged(SendComponent.this.fSendField);
                    SendComponent.this.messageEditor.updateItems();
                }
            }
        });
        transportOptionField.createControl((Composite)group, nColumns, 1);
        if (this.getWizardPage() instanceof OperationWizardPage) {
            OperationWizardPage wizardPage = (OperationWizardPage)this.getWizardPage();
            try {
                Element element = wizardPage.getElementForOperation();
                if (this.fSendField.getText().isEmpty()) {
                    this.messageEditor.displayElement(element, true);
                }
            }
            catch (Exception exception) {}
        }
        return group;
    }

    public String getXmlText() {
        return this.fSendField.getText();
    }

    public void setXmlText(String xml) {
        this.fSendField.setTextWithoutUpdate(xml);
    }

    public String getDelaySequence() {
        return this.fDelaySelected ? this.fDelayStringField.getText() : "";
    }

    @Override
    public void messageChanged(Element input) {
        this.setOperationMessage(input, true);
    }

    public void setOperationMessage(Element inputElement, boolean notifyListener) {
        this.messageEditor.displayElement(inputElement, notifyListener);
    }

    @Override
    public void valueChanged(String newValue) {
        this.fSendField.setText(newValue);
    }
}

