/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import java.util.HashMap;
import java.util.Map;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.sections.BPELUnitSection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class StructuredSection
extends BPELUnitSection {
    public static String BUTTON_ADD = "ADD";
    private static final String BUTTON_ADD2 = "ADD2";
    public static String BUTTON_REMOVE = "REMOVE";
    public static String BUTTON_EDIT = "EDIT";
    public static String BUTTON_DUPLICATE = "DUPLICATE";
    public static final String BUTTON_UP = "UP";
    public static final String BUTTON_DOWN = "DOWN";
    private Map<String, Button> fButtons;
    private boolean fEnableUpDownButtons;
    private boolean fEnableDuplicateButton;
    private Composite buttonsContainer;
    private String fAdd2ndButtonLabel;

    public Composite getButtonsContainer() {
        return this.buttonsContainer;
    }

    public StructuredSection(Composite parent, FormToolkit toolkit, TestSuitePage page) {
        this(parent, toolkit, page, false);
    }

    public StructuredSection(Composite parent, FormToolkit toolkit, TestSuitePage page, boolean enableUpDownButtons) {
        this(parent, toolkit, page, enableUpDownButtons, false, null);
    }

    public StructuredSection(Composite parent, FormToolkit toolkit, TestSuitePage page, boolean enableUpDownButtons, boolean enableDuplicateButton, String add2ButtonLabel) {
        super(page, parent, toolkit, 384);
        this.fEnableUpDownButtons = enableUpDownButtons;
        this.fEnableDuplicateButton = enableDuplicateButton;
        this.fAdd2ndButtonLabel = add2ButtonLabel;
        this.createClient(this.getSection(), toolkit);
    }

    protected abstract String getName();

    protected abstract String getDescription();

    protected abstract void createStructuredViewer(Composite var1);

    public abstract StructuredViewer getViewer();

    protected abstract void itemSelected(Object var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    protected abstract void addPressed();

    protected void add2Pressed() {
    }

    protected abstract void editPressed();

    protected abstract void removePressed();

    protected void downPressed() {
    }

    protected void upPressed() {
    }

    protected void duplicatePressed() {
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.fButtons = new HashMap<String, Button>();
        section.setText(this.getName());
        section.setDescription(this.getDescription());
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createStructuredViewer(container);
        this.getViewer().getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                StructuredSection.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent event) {
                StructuredSection.this.handleKeyReleased(event);
            }
        });
        this.buttonsContainer = toolkit.createComposite(container);
        this.buttonsContainer.setLayout((Layout)this.createButtonsLayout());
        GridData gd = new GridData(1040);
        this.buttonsContainer.setLayoutData((Object)gd);
        Button addButton = this.createButton(this.buttonsContainer, "&Add...", toolkit);
        this.fButtons.put(BUTTON_ADD, addButton);
        if (this.fAdd2ndButtonLabel != null) {
            Button add2Button = this.createButton(this.buttonsContainer, this.fAdd2ndButtonLabel, toolkit);
            this.fButtons.put(BUTTON_ADD2, add2Button);
            add2Button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    StructuredSection.this.add2Pressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSection.this.add2Pressed();
                }
            });
        }
        Button editButton = this.createButton(this.buttonsContainer, "&Edit...", toolkit);
        this.fButtons.put(BUTTON_EDIT, editButton);
        Button removeButton = this.createButton(this.buttonsContainer, "Remove", toolkit);
        this.fButtons.put(BUTTON_REMOVE, removeButton);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StructuredSection.this.addPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSection.this.addPressed();
            }
        });
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StructuredSection.this.removePressed();
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSection.this.removePressed();
            }
        });
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StructuredSection.this.editPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSection.this.editPressed();
            }
        });
        addButton.setLayoutData((Object)this.createButtonLayoutData());
        editButton.setLayoutData((Object)this.createButtonLayoutData());
        removeButton.setLayoutData((Object)this.createButtonLayoutData());
        if (this.fEnableDuplicateButton) {
            Button duplicateButton = this.createButton(this.buttonsContainer, "Duplicate", toolkit);
            this.fButtons.put(BUTTON_DUPLICATE, duplicateButton);
            duplicateButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSection.this.duplicatePressed();
                }
            });
            duplicateButton.setLayoutData((Object)this.createButtonLayoutData());
        }
        if (this.fEnableUpDownButtons) {
            Label spacer = new Label(this.buttonsContainer, 0);
            spacer.setLayoutData((Object)this.createButtonLayoutData());
            Button upButton = this.createButton(this.buttonsContainer, "Up", toolkit);
            this.fButtons.put(BUTTON_UP, upButton);
            upButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSection.this.upPressed();
                }
            });
            upButton.setLayoutData((Object)this.createButtonLayoutData());
            Button downButton = this.createButton(this.buttonsContainer, "Down", toolkit);
            this.fButtons.put(BUTTON_DOWN, downButton);
            downButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSection.this.downPressed();
                }
            });
            downButton.setLayoutData((Object)this.createButtonLayoutData());
        }
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.setEditRemoveDuplicateEnabled(false);
    }

    private GridData createButtonLayoutData() {
        return new GridData(4, 1, false, false);
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 127) {
            this.removePressed();
        }
    }

    protected void handleKeyReleased(KeyEvent event) {
    }

    protected Button createButton(Composite parent, String label, FormToolkit toolkit) {
        Button button;
        if (toolkit != null) {
            button = toolkit.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        return button;
    }

    protected GridLayout createButtonsLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = span;
        container.setLayout((Layout)layout);
        return container;
    }

    public void setViewerInput(Object input) {
        this.setEditRemoveDuplicateEnabled(false);
        this.getViewer().setInput(input);
    }

    protected void setEnabled(String button, boolean enabled) {
        this.fButtons.get(button).setEnabled(enabled);
    }

    protected void setEditRemoveDuplicateEnabled(boolean enabled) {
        this.fButtons.get(BUTTON_EDIT).setEnabled(enabled);
        this.fButtons.get(BUTTON_REMOVE).setEnabled(enabled);
        if (this.fEnableDuplicateButton) {
            this.fButtons.get(BUTTON_DUPLICATE).setEnabled(enabled);
        }
        if (this.fEnableUpDownButtons) {
            this.fButtons.get(BUTTON_UP).setEnabled(enabled);
            this.fButtons.get(BUTTON_DOWN).setEnabled(enabled);
        }
    }

    protected Object getViewerSelection() {
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    protected void hookMenu() {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                StructuredSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.getViewer().getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected Action createAction(IMenuManager newMenu, String text, Action newSendOnlyActivity) {
        newSendOnlyActivity.setText(text);
        newMenu.add((IAction)newSendOnlyActivity);
        return newSendOnlyActivity;
    }
}

