/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import net.bpelunit.framework.client.eclipse.ExtensionControl;
import net.bpelunit.framework.client.eclipse.dialog.field.FileSelector;
import net.bpelunit.framework.xml.suite.XMLPUTDeploymentInformation;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.formwidgets.ComboEntry;
import net.bpelunit.toolsupport.editors.formwidgets.ContextPart;
import net.bpelunit.toolsupport.editors.formwidgets.EntryAdapter;
import net.bpelunit.toolsupport.editors.formwidgets.FormEntry;
import net.bpelunit.toolsupport.editors.formwidgets.FormEntryAdapter;
import net.bpelunit.toolsupport.editors.formwidgets.TextEntry;
import net.bpelunit.toolsupport.editors.sections.BPELUnitSection;
import net.bpelunit.toolsupport.editors.wizards.DeploymentOptionWizard;
import net.bpelunit.toolsupport.util.WSDLFileFilter;
import net.bpelunit.toolsupport.util.WSDLFileValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PUTSection
extends BPELUnitSection
implements ContextPart,
IHyperlinkListener {
    private TextEntry fNameEntry;
    private ComboEntry fTypeEntry;
    private FormEntry fWSDLEntry;

    public PUTSection(Composite parent, TestSuitePage page, FormToolkit toolkit, int style) {
        super(page, parent, toolkit, style);
        this.createClient(this.getSection(), toolkit);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText("Process Under Test");
        section.setLayoutData((Object)new GridData(4, 1, true, false));
        section.setDescription("Enter a name, type, and WSDL file for the PUT.");
        Composite content = toolkit.createComposite((Composite)section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.rightMargin = toolkit.getBorderStyle() != 0 ? 0 : 2;
        layout.leftMargin = layout.rightMargin;
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        this.createNameEntry(content, toolkit);
        this.createTypeEntry(content, toolkit);
        this.createWSDLEntry(content, toolkit);
        this.createText(content, "<form><p><a href=\"deploymentOptions\">Configure Deployment Options...</a></p></form>", toolkit, this);
        section.setClient((Control)content);
        toolkit.paintBordersFor(content);
    }

    private void createWSDLEntry(Composite client, FormToolkit toolkit) {
        this.fWSDLEntry = new FormEntry(client, toolkit, "WSDL", "Browse...", true);
        this.fWSDLEntry.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                PUTSection.this.getPUT().setWsdl(entry.getValue());
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                PUTSection.this.handleChooseWSDLSelected();
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                PUTSection.this.handleChooseWSDLSelected();
            }
        });
        this.fWSDLEntry.setEditable(true);
    }

    protected void handleChooseWSDLSelected() {
        String currentFile = this.fWSDLEntry.getValue();
        IProject currentProject = this.getEditor().getCurrentProject();
        IContainer currentDirectory = this.getEditor().getCurrentDirectory();
        String path = FileSelector.getFile((Shell)this.getShell(), (String)currentFile, (ISelectionStatusValidator)new WSDLFileValidator(this.getEditor()), (ViewerFilter)new WSDLFileFilter(), (IProject)currentProject, (IContainer)currentDirectory);
        if (path != null) {
            this.fWSDLEntry.setValue(path);
            this.getPUT().setWsdl(path);
            this.manageTargetNamespace(path);
            this.markDirty();
        }
    }

    private void createNameEntry(Composite content, FormToolkit toolkit) {
        this.fNameEntry = new TextEntry(content, toolkit, "PUT Name", 4);
        this.fNameEntry.setFormEntryListener(new EntryAdapter(this){

            @Override
            public void textValueChanged(TextEntry entry) {
                PUTSection.this.getPUT().setName(entry.getValue());
            }
        });
    }

    private void createTypeEntry(Composite content, FormToolkit toolkit) {
        this.fTypeEntry = new ComboEntry(content, toolkit, "PUT Type");
        this.fTypeEntry.setItems(ExtensionControl.getDeployerMetaInformation());
        this.fTypeEntry.setFormEntryListener(new EntryAdapter(this){

            @Override
            public void textValueChanged(TextEntry entry) {
                PUTSection.this.getPUT().setType(entry.getValue());
            }
        });
    }

    public void refresh() {
        this.fNameEntry.setValue(this.getPUT().getName(), true);
        this.fTypeEntry.setValue(this.getPUT().getType(), true);
        this.fWSDLEntry.setValue(this.getPUT().getWsdl(), true);
        super.refresh();
    }

    @Override
    public void fireSaveNeeded() {
        this.markDirty();
    }

    private XMLPUTDeploymentInformation getPUT() {
        return this.getTestSuite().getDeployment().getPut();
    }

    public void linkActivated(HyperlinkEvent e) {
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new DeploymentOptionWizard(this.getPUT()));
        if (dialog.open() == 0) {
            this.markDirty();
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }
}

