/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.authorization;

import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.restclientv2.authorization.DefaultRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class DefaultAuthHeaderAuth
extends DefaultRequestAuth {
    private final String mAuthToken;
    private final String mApiKey;
    protected final String mDeviceId;
    protected final String mDeviceName;

    public DefaultAuthHeaderAuth(String authToken, String apiKey, String deviceId, String deviceName) {
        this.mAuthToken = authToken;
        this.mApiKey = apiKey;
        this.mDeviceId = deviceId;
        this.mDeviceName = deviceName;
    }

    public void setAuth(IBoxRequest request) throws BoxRestException, AuthFatalFailureException {
        super.setAuth(request);
        request.addHeader("Authorization", this.getAuthString().toString());
    }

    public StringBuilder getAuthString() {
        StringBuilder sbr = new StringBuilder();
        sbr.append("BoxAuth api_key=").append(this.mApiKey).append("&auth_token=").append(this.mAuthToken);
        try {
            sbr.append("&device_id=").append(URLEncoder.encode(this.mDeviceId, "UTF-8"));
            sbr.append("&device_name=").append(URLEncoder.encode(this.mDeviceName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sbr;
    }
}

