/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.responseparsers;

import com.box.boxjavalibv2.dao.BoxGenericServerError;
import com.box.boxjavalibv2.dao.BoxServerError;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedStatus;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxResponse;
import com.box.restclientv2.responseparsers.DefaultBoxJSONResponseParser;
import com.box.restclientv2.responses.DefaultBoxResponse;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ErrorResponseParser
extends DefaultBoxJSONResponseParser {
    private static final String RETRY_AFTER = "Retry-After";

    public ErrorResponseParser(IBoxJSONParser parser) {
        super(BoxServerError.class, parser);
    }

    public Object parse(IBoxResponse response) throws BoxRestException {
        if (!(response instanceof DefaultBoxResponse)) {
            throw new BoxRestException("class mismatch, expected:" + DefaultBoxResponse.class.getName() + ";current:" + response.getClass().getName());
        }
        HttpResponse httpResponse = ((DefaultBoxResponse)response).getHttpResponse();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        BoxServerError error = null;
        if (this.isErrorResponse(statusCode)) {
            error = (BoxServerError)super.parse(response);
        } else {
            Header header;
            error = new BoxUnexpectedStatus(statusCode);
            if (this.isRetryAccepted(statusCode) && (header = ((DefaultBoxResponse)response).getHttpResponse().getFirstHeader(RETRY_AFTER)) != null) {
                String value = header.getValue();
                ((BoxUnexpectedStatus)error).setRetryAfter(Integer.valueOf(value));
            }
            try {
                httpResponse.getEntity().consumeContent();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        error.setStatus(statusCode);
        return error;
    }

    protected Object parseInputStream(InputStream in) {
        String errorStr;
        block3: {
            errorStr = null;
            try {
                errorStr = IOUtils.toString((InputStream)in);
                Object obj = this.getParser().parseIntoBoxObject(errorStr, this.getObjectClass());
                if (obj instanceof BoxServerError) {
                    return obj;
                }
            }
            catch (Exception e) {
                if (!StringUtils.isEmpty((String)errorStr)) break block3;
                errorStr = e.getMessage();
            }
        }
        BoxGenericServerError genericE = new BoxGenericServerError();
        genericE.setMessage(errorStr);
        return genericE;
    }

    private boolean isErrorResponse(int statusCode) {
        return statusCode >= 400 && statusCode < 600;
    }

    private boolean isRetryAccepted(int statusCode) {
        return statusCode == 202;
    }
}

