/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateOAuthRequest;
import com.box.boxjavalibv2.requests.RefreshOAuthRequest;
import com.box.boxjavalibv2.requests.RevokeOAuthRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxOAuthRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxResourceManager;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;

public class BoxOAuthManager
extends BoxResourceManager {
    public BoxOAuthManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, null, restClient);
    }

    public BoxOAuthToken createOAuth(BoxOAuthRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateOAuthRequest request = new CreateOAuthRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxOAuthToken)this.getResponseAndParseAndTryCast(request, BoxResourceType.OAUTH_DATA, this.getJSONParser());
    }

    public BoxOAuthToken refreshOAuth(BoxOAuthRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        RefreshOAuthRequest request = new RefreshOAuthRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxOAuthToken)this.getResponseAndParseAndTryCast(request, BoxResourceType.OAUTH_DATA, this.getJSONParser());
    }

    public void revokeOAuth(BoxOAuthRequestObject requestObject) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        RevokeOAuthRequest request = new RevokeOAuthRequest(this.getConfig(), this.getJSONParser(), requestObject);
        this.executeRequestWithNoResponseBody(request);
    }
}

