/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.dao.BoxItem;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CopyItemRequest;
import com.box.boxjavalibv2.requests.CreateSharedLinkRequest;
import com.box.boxjavalibv2.requests.DeleteTrashItemRequest;
import com.box.boxjavalibv2.requests.GetItemRequest;
import com.box.boxjavalibv2.requests.GetTrashItemRequest;
import com.box.boxjavalibv2.requests.RestoreTrashItemRequest;
import com.box.boxjavalibv2.requests.UpdateItemInfoRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFileRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemRestoreRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxResourceManager;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import java.io.UnsupportedEncodingException;

public class BoxItemsManager
extends BoxResourceManager {
    public BoxItemsManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    public BoxItem getItem(String id, BoxDefaultRequestObject requestObject, BoxResourceType type) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetItemRequest request = new GetItemRequest(this.getConfig(), this.getJSONParser(), id, type, requestObject);
        Object result = this.getResponseAndParse(request, type, this.getJSONParser());
        return (BoxItem)this.tryCastBoxItem(type, result);
    }

    public BoxItem getTrashItem(String itemId, BoxResourceType type, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetTrashItemRequest request = new GetTrashItemRequest(this.getConfig(), this.getJSONParser(), itemId, type, requestObject);
        Object result = this.getResponseAndParse(request, type, this.getJSONParser());
        return (BoxItem)this.tryCastBoxItem(type, result);
    }

    public BoxItem copyItem(String id, BoxItemRequestObject requestObject, BoxResourceType type) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CopyItemRequest request = new CopyItemRequest(this.getConfig(), this.getJSONParser(), id, requestObject, type);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }

    public BoxItem updateItemInfo(String id, BoxItemRequestObject requestObject, BoxResourceType type) throws UnsupportedEncodingException, BoxRestException, BoxServerException, AuthFatalFailureException {
        UpdateItemInfoRequest request = new UpdateItemInfoRequest(this.getConfig(), this.getJSONParser(), id, requestObject, type);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }

    public BoxItem createSharedLink(String id, BoxItemRequestObject requestObject, BoxResourceType type) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateSharedLinkRequest request = new CreateSharedLinkRequest(this.getConfig(), this.getJSONParser(), id, requestObject, type);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }

    public void deleteTrashItem(String id, BoxResourceType type, BoxFileRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteTrashItemRequest request = new DeleteTrashItemRequest(this.getConfig(), this.getJSONParser(), id, type, (BoxDefaultRequestObject)requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    public BoxItem restoreTrashItem(String id, BoxResourceType type, BoxItemRestoreRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        RestoreTrashItemRequest request = new RestoreTrashItemRequest(this.getConfig(), this.getJSONParser(), id, type, requestObject);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }
}

