/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxGroup;
import com.box.boxjavalibv2.dao.BoxGroupMembership;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateGroupMembershipRequest;
import com.box.boxjavalibv2.requests.CreateGroupRequest;
import com.box.boxjavalibv2.requests.DeleteGroupMembershipRequest;
import com.box.boxjavalibv2.requests.DeleteGroupRequest;
import com.box.boxjavalibv2.requests.GetAllGroupsRequest;
import com.box.boxjavalibv2.requests.GetGroupCollaborationsRequest;
import com.box.boxjavalibv2.requests.GetGroupMembershipRequest;
import com.box.boxjavalibv2.requests.GetGroupMembershipsRequest;
import com.box.boxjavalibv2.requests.UpdateGroupMembershipRequest;
import com.box.boxjavalibv2.requests.UpdateGroupRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxGroupRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxResourceManager;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequestAuth;

public class BoxGroupsManager
extends BoxResourceManager {
    public BoxGroupsManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    public BoxCollection getAllGroups(BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetAllGroupsRequest request = new GetAllGroupsRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUPS, this.getJSONParser());
    }

    public BoxGroup createGroup(BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        CreateGroupRequest request = new CreateGroupRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxGroup)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP, this.getJSONParser());
    }

    public BoxGroup createGroup(String name) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        BoxGroupRequestObject requestObj = BoxGroupRequestObject.createGroupRequestObject(name);
        return this.createGroup(requestObj);
    }

    public BoxGroup updateGroup(String groupId, BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        UpdateGroupRequest request = new UpdateGroupRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        return (BoxGroup)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP, this.getJSONParser());
    }

    public void deleteGroup(String groupId, BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        DeleteGroupRequest request = new DeleteGroupRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    public BoxCollection getMemberships(String groupId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetGroupMembershipsRequest request = new GetGroupMembershipsRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIPS, this.getJSONParser());
    }

    public BoxGroupMembership getMembership(String membershipId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetGroupMembershipRequest request = new GetGroupMembershipRequest(this.getConfig(), this.getJSONParser(), membershipId, requestObject);
        return (BoxGroupMembership)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIP, this.getJSONParser());
    }

    public BoxGroupMembership createMembership(BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        CreateGroupMembershipRequest request = new CreateGroupMembershipRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxGroupMembership)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIP, this.getJSONParser());
    }

    public BoxGroupMembership createMembership(String groupId, String userId, String role) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        BoxGroupRequestObject obj = BoxGroupRequestObject.addMembershipRequest(groupId, userId, role);
        return this.createMembership(obj);
    }

    public BoxGroupMembership updateMembership(String membershipId, BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        UpdateGroupMembershipRequest request = new UpdateGroupMembershipRequest(this.getConfig(), this.getJSONParser(), membershipId, requestObject);
        return (BoxGroupMembership)this.getResponseAndParseAndTryCast(request, BoxResourceType.GROUP_MEMBERSHIP, this.getJSONParser());
    }

    public BoxGroupMembership updateMembership(String membershipId, String role) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        BoxGroupRequestObject obj = BoxGroupRequestObject.updateMembershipRequest(role);
        return this.updateMembership(membershipId, obj);
    }

    public void deleteMembership(String membershipId, BoxGroupRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        DeleteGroupMembershipRequest request = new DeleteGroupMembershipRequest(this.getConfig(), this.getJSONParser(), membershipId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    public BoxCollection getAllCollaborations(String groupId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetGroupCollaborationsRequest request = new GetGroupCollaborationsRequest(this.getConfig(), this.getJSONParser(), groupId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATIONS, this.getJSONParser());
    }
}

