/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.requests.requestobjects;

import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxJSONStringEntity;
import com.box.boxjavalibv2.interfaces.IBoxRequestObject;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.restclientv2.exceptions.BoxRestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxDefaultRequestObject
implements IBoxRequestObject {
    private IBoxJSONParser mParser;
    private final MapJSONStringEntity jsonEntity = new MapJSONStringEntity();
    private final List<String> fields = new ArrayList<String>();
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public IBoxJSONParser getJSONParser() {
        return this.mParser;
    }

    public void setJSONParser(IBoxJSONParser parser) {
        this.mParser = parser;
    }

    @Override
    public HttpEntity getEntity() throws BoxRestException {
        try {
            return new StringEntity(this.getJSONEntity().toJSONString(this.getJSONParser()), "UTF-8");
        }
        catch (Exception e) {
            throw new BoxRestException(e);
        }
    }

    public MapJSONStringEntity getJSONEntity() {
        return this.jsonEntity;
    }

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    public BoxDefaultRequestObject addField(String field) {
        this.getFields().add(field);
        return this;
    }

    public BoxDefaultRequestObject addFields(List<String> fields) {
        this.getFields().addAll(fields);
        return this;
    }

    public BoxDefaultRequestObject addQueryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public BoxDefaultRequestObject addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public IBoxJSONStringEntity put(String key, IBoxJSONStringEntity value) {
        return this.getJSONEntity().put(key, value);
    }

    public String put(String key, String value) {
        return this.getJSONEntity().put(key, value);
    }

    public String[] put(String key, String[] value) {
        return this.getJSONEntity().put(key, value);
    }

    public Object get(String key) {
        return this.getJSONEntity().get(key);
    }

    public BoxDefaultRequestObject setPage(int limit, int offset) {
        this.addQueryParam("limit", Integer.toString(limit));
        this.addQueryParam("offset", Integer.toString(offset));
        return this;
    }
}

