/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.authorization;

import com.box.boxjavalibv2.authorization.OAuthAuthorization;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.restclientv2.authorization.DefaultRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxRequest;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class SharedLinkAuthorization
extends DefaultRequestAuth {
    private static final String HEADER_NAME = "BoxApi";
    private final String mSharedLink;
    private String mPassword = null;
    private final OAuthAuthorization mOauth;

    public SharedLinkAuthorization(OAuthAuthorization oauth, String sharedLink, String password) {
        this.mOauth = oauth;
        this.mSharedLink = sharedLink;
        this.mPassword = password;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public void setAuth(IBoxRequest request) throws BoxRestException, AuthFatalFailureException {
        super.setAuth(request);
        this.mOauth.setAuth(request);
        request.addHeader(HEADER_NAME, this.getAuthString().toString());
    }

    public StringBuilder getAuthString() {
        StringBuilder sbr = new StringBuilder();
        sbr.append("shared_link=").append(this.mSharedLink);
        if (StringUtils.isNotEmpty((String)this.mPassword)) {
            sbr.append("&shared_link_password=").append(URLEncoder.encode(this.mPassword));
        }
        return sbr;
    }
}

