/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import java.util.UUID;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import net.blugrid.service.WebMailerConnector;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class WebMailerConnectorImpl
implements WebMailerConnector {
    private static final Logger logger = Logger.getLogger(WebMailerConnectorImpl.class);
    private static final String BASE_URL = "http://localhost:8080/v2.0/";

    @Override
    public Response sendEmail(Token token, UUID emailuuid) {
        Response response = new Response();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/web-mailer/sendmail";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("emailuuid", new Object[]{emailuuid});
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("Web mailer request:  " + uriBuilder.build().encode().toUri()));
            ResponseEntity restResponse = template.exchange(uriBuilder.build().encode().toUri(), HttpMethod.POST, requestEntity, Response.class);
            logger.info((Object)("web-mailer response: " + restResponse.getStatusCode()));
            response = (Response)restResponse.getBody();
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public Response receiveEmail(Token token, UUID emailuuid) {
        Response response = new Response();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/web-mailer/receivemail";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("emailuuid", new Object[]{emailuuid});
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("Web mailer request:  " + uriBuilder.build().encode().toUri()));
            ResponseEntity restResponse = template.exchange(uriBuilder.build().encode().toUri(), HttpMethod.POST, requestEntity, Response.class);
            logger.info((Object)("web-mailer response: " + restResponse.getStatusCode()));
            response = (Response)restResponse.getBody();
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public Response sendPasswordResetEmail(Token token, UUID emailuuid, String resetcode) {
        Response response = new Response();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/web-mailer/sendmail/passwordreset";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("emailuuid", new Object[]{emailuuid}).queryParam("resetcode", new Object[]{resetcode});
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("Web scaper request:  " + uriBuilder.build().encode().toUri()));
            ResponseEntity restResponse = template.exchange(uriBuilder.build().encode().toUri(), HttpMethod.POST, requestEntity, Response.class);
            logger.info((Object)("web-scraper response: " + restResponse.getStatusCode()));
            response = (Response)restResponse.getBody();
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        return response;
    }
}

