/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import java.io.File;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.FileUtils;
import net.blugrid.service.S3ServiceConnector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class S3ServiceConnectorImpl
implements S3ServiceConnector {
    private static final Logger logger = Logger.getLogger(S3ServiceConnectorImpl.class);
    @Autowired
    private FileUtils Fileutils;
    private static final String BASE_URL = "http://localhost:8080/v2.0/";
    private byte[] fileBytes;

    @Override
    public Response uploadFile(Token token, String bucketName, File file, String keyname) {
        Response response = new Response();
        RestTemplate template = new RestTemplate();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"bucket", (Object)bucketName);
        params.add((Object)"path", (Object)keyname);
        params.add((Object)"file", (Object)new FileSystemResource(file.getAbsolutePath()));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = "http://localhost:8080/v2.0/s3-service/file";
        try {
            logger.info((Object)("S3 service url:  " + url));
            ResponseEntity restResponse = template.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            logger.info((Object)("S3-service response: " + restResponse));
            response.setStatus("OK");
            response.setMessage((String)restResponse.getBody());
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public File getFile(Token token, String bucketName, String keyname) {
        Response response = new Response();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setBufferRequestBody(false);
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        template.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        String url = "http://localhost:8080/v2.0/s3-service/file?bucket=" + bucketName + "&path=" + keyname;
        try {
            logger.info((Object)("S3 service url:  " + url));
            String tempfile = "/data/temp/" + token.getSessionuuid().toString() + "_" + keyname.replaceAll("/", "");
            ResponseEntity restResponse = template.exchange(url, HttpMethod.GET, requestEntity, byte[].class, new Object[0]);
            logger.info((Object)("S3-service response: " + restResponse.getStatusCode()));
            String filename = keyname.replaceAll("/", "_");
            File file = this.Fileutils.convertByteArrayToFile(token, (byte[])restResponse.getBody(), filename);
            response.setStatus("OK");
            return file;
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
            return null;
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            response.setStatus("ERROR");
            response.setMessage(e.getMessage());
            return null;
        }
    }

    @Override
    public void DeleteFile(Token token, String bucketName, String keyname) {
        logger.info((Object)"S3 DeleteFile: ");
    }
}

