/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.blugrid.core.model.ExternalDataSyncProfile;
import net.blugrid.core.model.Party;
import net.blugrid.core.model.Token;
import net.blugrid.service.ExternalDataSyncProfileService;
import net.blugrid.service.WebscaperConnectorImpl;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ExternalDataSyncProfileServiceImpl
implements ExternalDataSyncProfileService {
    private static final Logger logger = Logger.getLogger(WebscaperConnectorImpl.class);
    private static final String BASE_URL = "http://localhost:8080/v2.0/";

    @Override
    public List<ExternalDataSyncProfile> getAll(Token token) {
        List<Object> response = new ArrayList<ExternalDataSyncProfile>();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/rest/externaldatasyncprofile";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("External data sync request:  " + uriBuilder.build().encode().toUri()));
            ResponseEntity restResponse = template.exchange(uriBuilder.build().encode().toUri(), HttpMethod.GET, requestEntity, String.class);
            logger.info((Object)("External data sync response: " + restResponse.getStatusCode()));
            String json = (String)restResponse.getBody();
            if (json != null) {
                Type listType = new TypeToken<ArrayList<ExternalDataSyncProfile>>(){}.getType();
                response = (List)new GsonBuilder().create().fromJson(json, listType);
            }
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        return response;
    }

    @Override
    public List<Party> getCustomerDataSyncPull(Token token, UUID uuid) {
        List<Object> response = new ArrayList<Party>();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/rest/externaldatasyncprofile/" + uuid.toString() + "/pull";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("External data sync request:  " + uriBuilder.build().encode().toUri()));
            ResponseEntity restResponse = template.exchange(uriBuilder.build().encode().toUri(), HttpMethod.GET, requestEntity, String.class);
            logger.info((Object)("External data sync response: " + restResponse.getStatusCode()));
            String json = (String)restResponse.getBody();
            if (json != null) {
                Type listType = new TypeToken<ArrayList<Party>>(){}.getType();
                response = (List)new GsonBuilder().create().fromJson(json, listType);
            }
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        return response;
    }
}

